(function($) {



    var form = $("#signup-form");
    form.validate({
        errorPlacement: function errorPlacement(error, element) {
            element.before(error);
        },
        onfocusout: function(element) {
            $(element).valid();
        },
    });
    form.children("div").steps({
        headerTag: "h3",
        bodyTag: "fieldset",
        transitionEffect: "fade",
        stepsOrientation: "vertical",
        titleTemplate: '<div class="title"><span class="step-number">#index#</span><span class="step-text">#title#</span></div>',
        labels: {
            previous: currentLang=="es"?"Anterior":"Back",
            next: currentLang=="es"?"Siguiente":"Next",
            finish: currentLang=="es"?"Finalizar":"Finish",
            current: ''
        },
        onStepChanging: function(event, currentIndex, newIndex) {
            //alert(currentIndex)
            if (currentIndex === 0) {
                form.parent().parent().parent().append('<div class="footer footer-' + currentIndex + '"></div>');
            }
            if (currentIndex === 1) {
                form.parent().parent().parent().find('.footer').removeClass('footer-0').addClass('footer-' + currentIndex + '');
            }
            if (currentIndex === 2) {
                form.parent().parent().parent().find('.footer').removeClass('footer-1').addClass('footer-' + currentIndex + '');
            }
            if (currentIndex === 3) {
                getTotals();
                form.parent().parent().parent().find('.footer').removeClass('footer-2').addClass('footer-' + currentIndex + '');
            }
             if(currentIndex === 4) {
                 
             }
            form.validate().settings.ignore = ":disabled,:hidden";

            return form.valid();
        },
        onFinishing: function(event, currentIndex) {
            form.validate().settings.ignore = ":disabled";
            return form.valid();
        },
        onFinished: function(event, currentIndex) {
            if(noPay){
                submitForm1();
            }
            
        },
        onStepChanged: function(event, currentIndex, priorIndex) {

            getSummary();
            return true;
        }
    });

    jQuery.extend(jQuery.validator.messages, {
        required: currentLang=="es"?"Este campo es obligatorio":"This field is mandatory",
        remote: "",
        email: "",
        url: "",
        date: "",
        dateISO: "",
        number: "",
        digits: "",
        creditcard: "",
        equalTo: ""
    });


})(jQuery);