<?php
session_start();
if(!function_exists("_")){
  function _($text){
    return $text;
  }
}

function delete_directory($dirname) {
  if (is_dir($dirname))
    $dir_handle = opendir($dirname);
  if (!$dir_handle)
    return false;
  while($file = readdir($dir_handle)) {
    if ($file != "." && $file != "..") {
      if (!is_dir($dirname."/".$file))
        unlink($dirname."/".$file);
      else
        delete_directory($dirname.'/'.$file);
    }
  }
  closedir($dir_handle);
  rmdir($dirname);
  return true;
}

$_SESSION["order"] = null;
if(!isset($no_redeclare)){
  require ("../core/entity/ActiveLang.php");
  require ("../core/entity/Abandoned.php");
  require ("../core/utils/Utils.php");
}else{
  $user = new UserAccount();
  $user->Id = $LoggedUser;
  $data_user = $user->GetRecord();
}

$utils = new Utils();
if($utils->ReturnSessionVar("tmp")!=""){
  delete_directory("../uploads/tmp/".$utils->ReturnSessionVar("tmp"));
}
if(isset($_GET["salt"])){
  $utils->SetSessionVar("tmp", $_GET["salt"]);
}else{
  $utils->SetSessionVar("tmp", $utils->GenerateLongString(5));
  mkdir("../uploads/tmp/".$utils->ReturnSessionVar("tmp"));
}
$lang = new ActiveLang();
$list = $lang->GetRecords();



$base = $no_redeclare?"https://roc.work/precisetranslations/wizard/":"";


$curr_language = ($_GET["lang"]=="en"?"en":"es");

if(isset($no_redeclare)){
    $curr_language = "en";
}


 $language = $curr_language=="en"?"en_US.utf8": "es_MX.utf8";
    putenv("LC_ALL=$language");
    setlocale(LC_ALL, $language);
    bindtextdomain('en_US', '/home/roc/public_html/precisetranslations/Locale');
    textdomain('en_US');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?=_("Precise Translations - Cotiza tu documento ahora")?></title>

    <script>
        var currentLang = '<?=$curr_language?>';
    </script>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300&display=swap" rel="stylesheet">
    <!-- Font Icon -->
    <link rel="stylesheet" href="<?=$base?>fonts/material-icon/css/material-design-iconic-font.min.css">
    <link rel="stylesheet" href="<?=$base?>vendor/nouislider/nouislider.min.css">

    <!-- Main css -->
    <link rel="stylesheet" href="<?=$base?>css/style.css">


    <style>

        .content {
            height: auto;
            min-height: 400px;
        }
        body{
            overflow-x: hidden;
        }
        .vertical .actions {
            float: left;
        }

        .current .title .step-number {
            background: #EC6F29;
            color: #fff;
        }

        span.step-number {
            height: 32px !important;
        }

        .actions ul li a {
            background: #232c52;
        }

        .form-group select{
            width: 100%;
            padding: 5px;
            border: 1px solid lightslategray;
        }

        input[type=radio], input[type=checkbox] {
            display: initial !important;
            height: initial !important;
            width: auto !important;
        }

        .btn {
            display: block;
            border: 1px solid #ebebeb;
            height: 50px;
            box-sizing: border-box;
            padding: 0 20px;
            color: #222;
            font-weight: bold;
            font-size: 14px;
            font-family: 'Roboto Slab';
            cursor: pointer;
        }

        .btn-primary{
            background: #232e5a;
            color: #fff;
        }

        .btn-danger{
            background: #ec6f29;
            color: #fff;
        }

        .scrollable{
            max-height: 300px;
            overflow-y: auto;
        }

        .radio {
            display: inline-block;
            border-radius: 0;
            background: #ebebeb !important;
            box-sizing: border-box;
            border: 2px solid lightgrey;
            cursor: pointer;
            margin: auto !important;
            padding: 10px;
        }

        .flexy{
            display: flex;
        }

        .vertical .steps {
            float: left;
            width: 20%;
        }
        .vertical .content, .vertical .actions{
            width: 80%;
            float: left;
        }

        .actions.clearfix {
            width: 100%;
        }
        #summary{
            width: 20%;
            background: white;
            padding: 10px;
        }

        select{
            width: 100%;
            display: block;
            border: 1px solid #ebebeb;
            height: 50px;
            box-sizing: border-box;
            padding: 0 20px;
            color: #222;
            font-size: 14px;
        }

        .alert-info{
            background: #64a3cd;
            color: white;
            padding: 5px;
        }
        .alert-stat{
            background: #dbdbdb;
            padding: 5px;
        }

        #more-words{
            display:none;
        }

        /*Card containing 2 cards*/
        .card0 {
            margin: 40px 12px 15px 12px;
            border: 0;
        }

        /*Left Side card*/
        .card1 {
            margin: 0;
            padding: 15px;
            padding-top: 25px;
            padding-bottom: 0px;
            background: #263238;
            height: 100%;
        }

        .bill-head {
            color: #ffffff;
            font-weight: bold;
            margin-bottom: 0px;
            margin-top: 0px;
            font-size: 30px;
        }

        .line {
            border-right: 1px grey solid;
        }

        .bill-date {
            color: #BDBDBD;
        }

        .red-bg {
            margin-top: 25px;
            margin-left: 0px;
            margin-right: 0px;
            background-color: #F44336;
            padding-left: 20px !important;
            padding: 25px 10px 25px 15px;
        }

        #total {
            margin-top: 0px;
            padding-left: 7px;
        }

        #total-label {
            margin-bottom: 0px;
            color: #ffffff;
            padding-left: 7px;
        }

        #heading1 {
            color: #ffffff;
            font-size: 20px;
            padding-left: 10px;
        }

        #heading2 {
            font-size: 27px;
            color: #D50000;
        }

        /*For font-awesome icons in Placeholder*/
        .placeicon {
            font-family: fontawesome !important;
        }

        /*Right Side Card*/
        .card2 {
            padding: 25px;
            margin: 0;
            height: 100%;
        }

        .form-card .pay {
            font-weight: bold;
        }

        .form-card input, .form-card textarea {
            padding: 10px 8px 10px 8px;
            border: none;
            border: 1px solid lightgrey;
            border-radius: 0px;
            margin-bottom: 25px;
            margin-top: 2px;
            width: 100%;
            box-sizing: border-box;
            font-family: montserrat;
            color: #2C3E50;
            font-size: 14px;
            letter-spacing: 1px;
        }

        .form-card input:focus, .form-card textarea:focus {
            -moz-box-shadow: none !important;
            -webkit-box-shadow: none !important;
            box-shadow: none !important;
            border: none;
            font-weight: bold;
            border: 1px solid gray;
            outline-width: 0;
        }

        .btn-info {
            color: #ffffff !important;
        }

        /*Imaged Radio Buttons*/
        .radio-group {
            position: relative;
            margin-bottom: 25px;
        }

        .radio {
            display:inline-block;
            width: 204;
            height: 64;
            border-radius: 0;
            background: lightblue;
            box-sizing: border-box;
            border: 2px solid lightgrey;
            cursor:pointer;
            margin: 8px 25px 8px 0px;
        }

        .radio:hover {
            box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.2);
        }

        .radio.selected {
            box-shadow: 0px 0px 0px 1px rgba(0, 0, 0, 0.4);
        }

        /*Fit image in bootstrap div*/
        .fit-image{
            width: 100%;
            object-fit: cover;
        }

        input {
            width: 100%;
            display: block;
            border: 1px solid #9a9a9a;
        }

        td{
            min-width: 250px;
        }

        .actions ul li:first-child a {
            background: #ec6f29;
            color: #ffffff;
        }

        #totals{
            background: #232e5a;
            padding: 18px;
            color: white;
        }

        label.error {
            display: block;
            position: relative;
            /* top: 0px; */
            /* bottom: -25px !important; */
            /* left: 11px; */
            color: red;
        }

        label.error:after {
            top: 0px;

        }

    </style>
</head>

<body>

<style>
    .msg-form{
        padding: 50px;
        background: white;
        text-align: center;
        min-height: 200px;
        display: flex;
        justify-content: center;
        align-items: center;
        display: none;
    }


</style>


   
    <script src="https://js.braintreegateway.com/web/dropin/1.33.4/js/dropin.js"></script>
<script>
    function addFiles(){
        $("#file").trigger("click");
    }

    function removeFileRow(node){
        $(node).parent().parent().remove();
    }
    function addFileRow(file){
        $("#filezone").append('<tr><td> <input type="hidden" name="File[]" value="'+file.path+'"> '+file.name+'</td><td><button class="btn btn-danger" onclick="removeFileRow(this)">-</button></td></tr>');
    }

    function saveAll(){
        $.post("<?=$base?>actions/save-form.php", $("#signup-form").serialize());
    }
    var token ="";
    var instance = null;
    var noPay = true;
    
    
    function submitForm1(){
        $.LoadingOverlay("show");
        $.post("<?=$base?>actions/send-request.php", $("#signup-form").serialize()).done(function(response){
            $.LoadingOverlay("hide");
            response = JSON.parse(response);
            if(response.type=="success"){
                $("#success-msg").show();
                $("#wrapper-form").hide();
            }else{
                $("#error-msg").show();
                $("#errorapi").text(response.msg)
                $("#wrapper-form").hide();
            }
        });
    }
    
    function saveForm(){
        saveAll();
    }

    document.addEventListener('DOMContentLoaded', function() {
        $.post("../braintree/token.php").done(function(result){
            token = result;
        });
        saveForm();
    });

    function checkWords(words){
        /*if(words>4000){
            $("#more-words").fadeIn();
        }else{
            $("#more-words").hide();
        }*/
    }

</script>

<style>
    .logo{
        filter: brightness(0) invert(1);

        padding: 10px;
    }
    .main{
        background: #232f60;
    }
    .floaty{
        float: right;
        margin-right: 35px;
        margin-top: 10px;
    }
    .floaty a {
        color: white;
        text-decoration: none;
        font-weight: bold;
        font-size: 15px;
        padding: 10px;
        transition: 0.5s;
    }
    .floaty a:hover{
        background: #ec6f29;;
    }
    .floaty ul{
        list-style: none;
    }
    .floaty li{
        display: inline-block;
        margin-top: 10px;
    }

    @media (max-width: 600px) {
        .steps.clearfix {
            display: none;
        }
        .flexy {
            display: initial;
            /* flex-wrap: nowrap; */
        }

        .container {
            width: 100% !important;
            margin: 0;
            background: #fff;
        }
        #summary {
            width: 100%;
            background: white;
            /* padding: 10px; */
        }

        fieldset {
            width: 100%;
            padding: 10px;
            background: white;
        }

        .form-flex .form-group {
            width: 100%;
            padding: 0 10px;
        }
        .vertical .content, .vertical .actions {
            margin: auto;
        }

    }



</style>
<div class="main" style="padding-top: 0">
  <?php
  if(!isset($no_redeclare)){
    ?>
      <img class="logo" width="200" src="snippets/logo_en.png" alt="">
      <div class="floaty">
          <ul>
              <li><a href="index.php"><?=_("Inicio")?></a></li>
              <li><a href="../client/login.php"><?=_("Login")?></a></li>
              <li><a href="https://precisetranslations.com"><?=_("Acerca de")?></a></li>
              <li><a href="https://precisetranslations.com"><?=_("Servicios")?></a></li>
              <li><a href="https://precisetranslations.com"><?=_("Contacto")?></a></li>
              <li><a href="<?=($curr_language=="es"?"?lang=en":"?lang=es")?>"><?=($curr_language=="es"?"English":"Español")?></a></li>
          </ul>
      </div>
    <?php
  }
  ?>
    <div class="flexy" id="wrapper-form">
        <div class="container">
            <form id="signup-form" autocomplete="off" >
                <div>
                  <?php
                  if(!isset($no_redeclare)){
                  ?>
                      <h3><?=_("Información de cuenta")?></h3>
                      <fieldset>
                          <h2><?=_("Bienvenido a Precise Translations");?></h2>
                          <p><?=_("A través de esta aplicación podrás obtener tu cotización o presupuesto estimado de acuerdo a la cantidad de páginas de todos tus trabajos y el tipo o especialización de tu proyecto de traducción. Por favor lee cuidadosamente cada formulario y rellena la información adecuada.")?></p>
                          <h2><?=_("Información personal")?></h2>
                          <p class="desc"><?=_("Por favor, añade la siguiente información para continuar el proceso")?></p>
                          <div class="fieldset-content">
                              <div class="form-row">
                                  <label class="form-label"><?=_("Nombre completo")?></label>
                                  <div class="form-flex">
                                      <div class="form-group">
                                          <input type="text" <?=isset($data_user)?"readonly":""?> value="<?=$data_user["FullName"]?>" name="FullName" required />
                                      </div>
                                  </div>
                              </div>
                              <div class="form-group">
                                  <label for="email" class="form-label"><?=_("Email")?></label>
                                  <input type="email" name="Email"  <?=isset($data_user)?"readonly":""?> value="<?=$data_user["Email"]?>" id="email" required />
                              </div>
                              <div class="form-group">
                                  <label for="phone" class="form-label"><?=_("Teléfono celular")?></label>
                                  <input required type="text" name="Phone" placeholder="(555) 555-5555"  <?=isset($data_user)?"readonly":""?> value="<?=$data_user["Phone"]?>" id="phone" />
                              </div>
                          </div>
                      </fieldset>
                    <?php
                  }?>


                    <h3><?=_("Detalles de traducción")?></h3>
                    <fieldset>

                        <?php if(isset($no_redeclare)){
                            ?>
                            <input type="hidden" <?=isset($data_user)?"readonly":""?> value="<?=$data_user["FullName"]?>" name="FullName" required />

                            <input type="hidden" name="Email"  <?=isset($data_user)?"readonly":""?> value="<?=$data_user["Email"]?>" id="email" required />

                            <input required type="hidden" name="Phone" placeholder="(555) 555-5555"  <?=isset($data_user)?"readonly":""?> value="<?=$data_user["Phone"]?>" id="phone" />

                          <?php

                        }?>

                        <h2><?=_("Detalles de traducción")?></h2>
                        <p class="desc"><?=_("Ingresa la información requerida de la traducción")?></p>
                        <div class="fieldset-content">
                            <div class="form-row">
                                <h5><?=_("Tipo de traducción")?></h5>
                                <div class="radio">
                                    <label><input type="radio" name="Certification" value="0" >
                                        <strong>
                                          <?=_("Traducción estándar")?>
                                        </strong>
                                        <p><?=_("Traducciones de uso personal, ideal para informes, proyectos escolares, minutas, libros, traducción automática usando nuestro poderoso software")?></p>
                                    </label>
                                </div>
                                <div class="radio">
                                    <label><input checked type="radio" name="Certification" value="1"  >
                                        <strong>
                                          <?=_("Traducción certificada")?>
                                        </strong>
                                        <p><?=_("Traducciones especializadas supervisada por nuestro equipo profesional de traductores, ideal para reportes, investigaciones, cartas legales,etc.")?></p>
                                    </label>
                                </div>
                            </div>
                            <script>
                                function checkLangs(){
                                    fromlang = $("#fromlang").val();
                                    tolang =  $("#tolang").val();
                                    $("#fromlang option").prop("disabled",false);
                                    $("#tolang option").prop("disabled",false);
                                    //$("#tolang option").attr("disabled","");
                                    $("#fromlang option[value='"+tolang+"']").prop("disabled",true);
                                    $("#tolang option[value='"+fromlang+"']").prop("disabled",true);
                                }
                                document.addEventListener("DOMContentLoaded", function(event) {
                                    checkLangs();
                                });

                                function interchange(){
                                    const rdo = $("#tolang").val();

                                    $("#tolang").val($("#fromlang").val()).trigger("change");
                                    $("#fromlang").val(rdo).trigger("change");
                                    checkLangs();
                                }
                            </script>
                            <div class="form-row">
                                <h5><?=_("Traducción requerida")?></h5>
                                <div class="form-flex">
                                    <div class="form-group">
                                        <label for=""><?=_("¿De qué idioma?")?></label>

                                        <select id="fromlang" required data-index="0" name="FromLang" class="form-control" onchange="checkLangs()">
                                            <option value="" disabled selected>Selecciona un idioma...</option>
                                          <?php
                                          $i = 1;
                                          foreach ($list as $item) {
                                            ?>
                                              <option value="<?= $item["Id"] ?>" <?=$i++=="2"?"selected":""?>>
                                                <?=$utils->getNameTranslation($item["LangName"])." (".$item["LangName"].")"?>
                                              </option>
                                            <?php
                                          }
                                          ?>
                                        </select>
                                    </div>
                                    <div class="form-group" style="width: 50px; padding-top: 22px;">
                                        <button class="btn btn-primary" type="button" onclick="interchange()">↔</button>
                                    </div>
                                    <div class="form-group">
                                        <label for=""><?=_("¿A qué idioma?")?></label>
                                        <select id="tolang" required data-index="0" name="ToLang" class="form-control"  onchange="checkLangs()">
                                            <option value="" disabled selected>Selecciona un idioma...</option>
                                          <?php
                                          foreach ($list as $item) {
                                            ?>
                                              <option value="<?= $item["Id"] ?>" >
                                                <?=$utils->getNameTranslation($item["LangName"])." (".$item["LangName"].")"?>
                                              </option>
                                            <?php
                                          }
                                          ?>
                                        </select>
                                    </div>

                                </div>
                                <div class="form-flex">
                                    <div class="form-group">
                                        <label class="form-label"><?=_("Cantidad de páginas")?></label>
                                        <input required min="1" type="text" name="Words" id="words" onkeyup="checkWords(this.value)" />
                                    </div>
                                    <div class="form-group">
                                        <div class="alert alert-stat">
                                          <?=_("Si no estás seguro de la cantidad de páginas")?> <a
                                                    href="https://www.precisetranslations.com/quote.php" style="color: blue; font-weight: bold;"><?=_("Contáctanos")?></a> <?=_("y nosotros haremos el cálculo, un ejecutivo te contactará en un momento")?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="alert alert-default">
                                <strong><?=_("Nota:"); ?> </strong>
                              <?=_("Una página tiene un aproximado de 250 palabras y se cotiza de acuerdo al idioma seleccionado, si no estás seguro de la cotización, por favor cotiza en nuestra página y nos contactaremos con gusto")?>
                            </div>
                            <div class="form-row">
                                <h5><?=_("Método de entrega")?></h5>
                                <div class="form-flex">
                                    <div class="form-group">
                                        <select required data-index="0" name="Delivery" class="form-control" onchange="checkDelivery(this.value)">
                                            <option value="" selected><?=_("selecciona una opción..")?></option>
                                            <option value="Email"><?=_("Email")?></option>
                                            <option value="Oficina"><?=_("En oficinas")?></option>
                                            <option value="USPS">USPS</option>
                                            <option value="Otro"><?=_("Otro medio")?></option>
                                        </select>
                                    </div>
                                </div>
                                <div id="other" style="display: none">
                                    <div class="form-group">
                                        <label class="form-label"><?=_("Especificar medio de entrega")?></label>
                                        <input type="text" name="Other"  />
                                    </div>
                                </div>
                                <div id="address-details" style="display: none">
                                    <div class="form-flex">
                                        <div class="form-group">
                                            <label class="form-label"><?=_("Domicilio exterior")?></label>
                                            <input type="text" name="FullAddress"  />
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label"><?=_("Domicilio interior")?></label>
                                            <input type="text" name="InteriorAddress"  />
                                        </div>
                                    </div>
                                    <div class="form-flex">
                                        <div class="form-group">
                                            <label class="form-label"><?=_("Ciudad")?></label>
                                            <input type="text" name="City"  />
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label"><?=_("Estado")?></label>
                                            <input type="text" name="State"  />
                                        </div>
                                        <div class="form-group">
                                            <label class="form-label"><?=_("Código postal")?></label>
                                            <input type="text" name="Zip"  />
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <script>
                                function checkDelivery(delivery){
                                    if(delivery==="USPS"){
                                        $("#address-details").show();
                                    }else{
                                        $("#address-details").hide();
                                    }
                                    if(delivery==="Otro"){
                                        $("#other").show();
                                    }else{
                                        $("#other").hide();
                                    }
                                }
                            </script>
                            <div class="form-row">
                                <h5><?=_("Extras")?></h5>
                                <label for="urgent" class="option">
                                    <input type="checkbox" id="urgent" name="Urgent" value="1">
                                  <?=_("Trabajo urgente")?>
                                </label>
                                <label for="apostillado" class="option">
                                    <input type="checkbox" id="apostillado" name="Apostillado" value="1">
                                  <?=_("Apostillado")?>
                                </label>
                                <label for="transcript" class="option">
                                    <input type="checkbox" id="transcript" name="Transcript" value="1">
                                  <?=_("Transcripción")?>
                                </label>
                                <label for="locale" class="option">
                                    <input type="checkbox" id="locale" name="Locale" value="1">
                                  <?=_("Localización")?>
                                </label>
                            </div>

                        </div>
                    </fieldset>

                    <h3><?=_("Archivos a traducir")?></h3>
                    <fieldset>
                        <h2><?=_("Añade tus archivos a traducir")?></h2>
                        <iframe width="100%" height="400" src="../core/filemanager/drop.php?uk=<?=$utils->ReturnSessionVar("tmp")?>" frameborder="0"></iframe>
                        <!--<input type="file" id="file" name="file" style="display: none" onchange="uploadFileNow(this)" />
                            <button class="btn btn-primary" type="button" onclick="addFiles()">+ <?=_("Añadir archivo")?></button>
                            <br>
                            <table class="table table-bordered">
                                <tbody id="filezone">
                                </tbody>
                            </table>-->
                    </fieldset>

                    <h3><?=_("Términos y condiciones")?></h3>
                    <fieldset>
                        <h2><?=_("Términos y condiciones")?></h2>
                        <br>
                        <style>
                            .scrollable p {
                                margin: 0;
                                font-size: 12px !important;
                            }
                        </style>
                        <div class="scrollable">
                            <p>Terms of Service</p>
                            <p>Last modified on September 20, 2019</p>
                            <p>Welcome to&nbsp;PGT.&nbsp;PGT&nbsp;is a global language services provider.</p>
                            <p>Precise Global Translations, Inc.&nbsp;(&ldquo;PGT,&rdquo; &ldquo;we,&rdquo; &ldquo;us,&rdquo; &ldquo;our&rdquo;) provides its services</p>
                            <p>(described below) to you through its websites&nbsp;(collectively, the &ldquo;Site&rdquo;) and through</p>
                            <p>its related services (collectively, such services, including any new features and</p>
                            <p>applications, and the Site, the &ldquo;Service(s)&rdquo;), subject to the following Terms of</p>
                            <p>Service (as amended occasionally, the &ldquo;Terms of Service&rdquo;). These Terms of</p>
                            <p>Service shall apply to all circumstances and matters arising from or relating to the</p>
                            <p>use of the Services and any other platforms or applications that reference these</p>
                            <p>Terms of Service.</p>
                            <p>&ldquo;You&rdquo; and &ldquo;your&rdquo; refers to you, a visitor to or user&nbsp;of the Site or Services. If you</p>
                            <p>agree to these Terms of Service on behalf of a company or other legal entity by</p>
                            <p>using the Services on such entity&rsquo;s behalf, you represent and warrant that you</p>
                            <p>have the authority to bind that company or other legal entity to&nbsp;these Terms of</p>
                            <p>Service, and, in such event, &ldquo;you&rdquo; and &ldquo;your&rdquo; refer to that company or other legal</p>
                            <p>entity.</p>
                            <p>We reserve the right, at our sole discretion, to change or modify portions of these</p>
                            <p>Terms of Service at any time. If we do so, we will post the changes on this page</p>
                            <p>along with the date these terms were last revised. If we make material changes to</p>
                            <p>our Terms of Service, we will notify you by email (if you have provided an email</p>
                            <p>address to us) and/or by pop-up notification on the Site. Your continued use&nbsp;of the</p>
                            <p>Service after the date any such changes become effective constitutes your</p>
                            <p>acceptance of the new Terms of Service. If you do not agree to abide by these or</p>
                            <p>any future Terms of Service, do not use or access (or continue to use or access)</p>
                            <p>the Service.</p>
                            <p>In addition, when using the Services, you may be subject to any additional terms</p>
                            <p>that may be posted on the Service from time to time, including, without limitation,</p>
                            <p>the Privacy Policy located at&nbsp;https://precisetranslations.com/legal/privacy-policy. All</p>
                            <p>such terms are hereby incorporated by reference into these Terms of Service.</p>
                            <p>IMPORTANT NOTICE: THIS AGREEMENT PROVIDES THAT ALMOST ALL</p>
                            <p>DISPUTES BETWEEN YOU AND US ARE SUBJECT TO BINDING</p>
                            <p>ARBITRATION AND A WAIVER OF CLASS ACTION RIGHTS AS DETAILED IN</p>
                            <p>THE ARBITRATION AND CLASS ACTION WAIVER SECTION BELOW. BY</p>
                            <p>ENTERING THIS AGREEMENT, YOU GIVE UP YOUR RIGHT&nbsp;TO&nbsp;SUE IN</p>
                            <p>COURT, OR TO BE PART OF A CLASS ACTION, TO RESOLVE THESE</p>
                            <p>DISPUTES, AS EXPLAINED IN MORE DETAIL IN THAT SECTION.</p>
                            <p>Access and Use of the Service</p>
                            <div><br></div>
                            <p>The Service&nbsp;provides efficient online interpretation, translation, and other</p>
                            <p>document-related services.</p>
                            <p>Registration: You may have to register with&nbsp;PGT&nbsp;to access and use certain</p>
                            <p>features of the Service. If you register for the Service, you agree to provide and</p>
                            <p>maintain true, accurate, current and complete information about yourself as</p>
                            <p>prompted by the Service&apos;s registration form(s). Personal information you provide</p>
                            <p>when registering is governed by our Privacy Policy. If you are under 16, you may</p>
                            <p>not use the Service, with or without registering. In addition, if you are under 18, you</p>
                            <p>may use the Service, with or without registering, only with your parent or guardian&rsquo;s</p>
                            <p>approval.</p>
                            <p>Account, Password, and Security: You are responsible for maintaining the</p>
                            <p>confidentiality of your password and account. You are also responsible for any</p>
                            <p>activities that occur under your password or account. You agree to (a) immediately</p>
                            <p>notify&nbsp;PGT&nbsp;of any unauthorized use of your password or account or any other</p>
                            <p>breach of security, and (b) ensure that you log out of your account at the end of</p>
                            <p>each session when accessing the Service.&nbsp;PGT&nbsp;will not be liable for any loss or</p>
                            <p>damage arising from&nbsp;your failure to comply with this Section.</p>
                            <p>Modifications to Service:&nbsp;PGT&nbsp;reserves the right to modify or discontinue,</p>
                            <p>temporarily or permanently, the Service(s) (or any part thereof) with or without</p>
                            <p>notice. You agree that&nbsp;PGT&nbsp;will not be liable to you or to any third party for any</p>
                            <p>modification, suspension or discontinuance of the Service.</p>
                            <p>Use, Storage, and Data Retention: You acknowledge that&nbsp;PGT&nbsp;may establish</p>
                            <p>general practices, policies, and limitations concerning the Service, including</p>
                            <p>without limitation&nbsp;the maximum time that documents, data, or other content will be</p>
                            <p>retained by the Service and the maximum storage space allotted on&nbsp;PGT&rsquo;s servers</p>
                            <p>on your behalf. You agree that&nbsp;PGT&nbsp;has no responsibility or liability for the deletion</p>
                            <p>or failure to store any documents, data, or other content maintained or uploaded by</p>
                            <p>the Service. You acknowledge that&nbsp;PGT&nbsp;reserves the right to terminate accounts</p>
                            <p>that are inactive for an extended period of time. You further acknowledge that&nbsp;PGT</p>
                            <p>reserves the right to change these&nbsp;general practices and limits at any time, in its</p>
                            <p>sole discretion, with or without notice.</p>
                            <p>Conditions of Use</p>
                            <p>User Conduct: You are solely responsible for all documents, information, data, text,</p>
                            <p>images, software, music, videos, sound, photographs, graphics,&nbsp;messages or other</p>
                            <p>materials (&ldquo;content&rdquo;) that you upload, post, publish or display (&ldquo;upload&rdquo;); email; or</p>
                            <p>otherwise use or transmit via the Service.</p>
                            <p>The following are examples of the content and/or use that is illegal or prohibited by</p>
                            <p>PGT.&nbsp;PGT&nbsp;reserves the right to investigate and take appropriate legal action</p>
                            <p>against anyone who, in&nbsp;PGT&apos;s sole discretion, violates this provision, including</p>
                            <p>without limitation, removing the offending content from the Service, suspending or</p>
                            <div><br></div>
                            <p>terminating the account of such violators, and reporting violators to any relevant</p>
                            <p>law enforcement authorities.</p>
                            <p>You agree to not use the Service to email, transmit, or otherwise upload any</p>
                            <p>content that:</p>
                            <p>&bull;&nbsp;infringes any intellectual property or other proprietary rights of any party;</p>
                            <p>&bull;&nbsp;you do not have a right to upload under any law or under contractual or</p>
                            <p>fiduciary relationships;</p>
                            <p>&bull;&nbsp;contains software viruses or any other computer code, files or programs</p>
                            <p>designed to interrupt, destroy or limit the functionality of any computer</p>
                            <p>software or hardware or telecommunications equipment;</p>
                            <p>&bull;&nbsp;poses or creates a privacy or security risk to any person;</p>
                            <p>&bull;&nbsp;constitutes unsolicited or unauthorized advertising, promotional materials,</p>
                            <p>commercial activities and/or sales, &ldquo;junk mail,&rdquo; &ldquo;spam,&rdquo; &ldquo;chain letters,&rdquo;</p>
                            <p>&ldquo;pyramid schemes,&rdquo; &ldquo;contests,&rdquo; &ldquo;sweepstakes,&rdquo; or any other form of</p>
                            <p>solicitation;</p>
                            <p>&bull;&nbsp;is unlawful, harmful, threatening, abusive, harassing, tortious, excessively</p>
                            <p>violent, defamatory, vulgar, obscene, pornographic, libelous, invasive of</p>
                            <p>another&apos;s privacy, hateful racially, ethnically or otherwise objectionable; or</p>
                            <p>&bull;&nbsp;in the sole judgment of&nbsp;PGT, is objectionable or which restricts or inhibits</p>
                            <p>any other person from using or enjoying the Service, or which may:</p>
                            <p>1.&nbsp;expose&nbsp;PGT&nbsp;or its users to any harm or liability of any type;</p>
                            <p>2.&nbsp;interfere with or disrupt the Service or servers or networks connected</p>
                            <p>to the Service, or disobey any requirements, procedures, policies or</p>
                            <p>regulations of networks connected to the Service;</p>
                            <p>3.&nbsp;violate any local, state, national or international law, or any</p>
                            <p>regulations having the force of law;</p>
                            <p>4.&nbsp;impersonate any person or entity, or falsely state or otherwise</p>
                            <p>misrepresent your affiliation with a person or entity;</p>
                            <p>5.&nbsp;solicit any personally identifiable information from anyone under the</p>
                            <p>age of 18;</p>
                            <p>6.&nbsp;harvest or collect email addresses or other contact information of</p>
                            <p>other users from the Service by electronic or other means to send</p>
                            <p>unsolicited emails or other unsolicited communications;</p>
                            <p>7.&nbsp;advertise or offer to sell or buy any goods or services for any</p>
                            <p>business purpose not specifically authorized;</p>
                            <p>8.&nbsp;further or promote any criminal activity or enterprise&nbsp;or provide</p>
                            <p>instructional information about illegal activities; or</p>
                            <p>9.&nbsp;obtain or attempt to access or otherwise obtain any materials or</p>
                            <p>information through any means not intentionally provided for through</p>
                            <p>the Service.</p>
                            <p>Fees: To use the Services, you will have to make one or more payments and</p>
                            <p>provide&nbsp;PGT&nbsp;information regarding your credit card or other payment instrument.</p>
                            <p>You represent and warrant to&nbsp;PGT&nbsp;that such information is true and that you are</p>
                            <div><br></div>
                            <p>authorized to use the payment instrument information you provide. You agree to</p>
                            <p>promptly update your account information with any changes (for example, a</p>
                            <p>change in your billing address or credit card expiration date) that may occur. You</p>
                            <p>agree to pay&nbsp;PGT&nbsp;the amount specified in the Service at the point of sale, prior to</p>
                            <p>the commencement of services.</p>
                            <p>PGT&nbsp;may bill through an invoice, in which case, full payment for invoices issued in</p>
                            <p>any month must be received by&nbsp;PGT&nbsp;thirty (30) days after the mailing date of the</p>
                            <p>invoice, or the Services may be suspended. Unpaid invoices are subject to a</p>
                            <p>finance charge of 1.5% per month on any outstanding balance, or the maximum</p>
                            <p>permitted by law, plus all expenses of collection.</p>
                            <p>If you dispute any charges you must let&nbsp;PGT&nbsp;know within sixty (60) days after the</p>
                            <p>date that&nbsp;PGT&nbsp;invoices you. We reserve the right to change&nbsp;PGT&apos;s prices at any</p>
                            <p>time for any reason. If&nbsp;PGT&nbsp;does change prices,&nbsp;PGT&nbsp;will provide notice of the</p>
                            <p>change on the Site or in email to you, at&nbsp;PGT&apos;s option. Your continued use of the</p>
                            <p>Service after the price change becomes effective&nbsp;constitutes your agreement to</p>
                            <p>pay the changed amount.</p>
                            <p>International Use: Recognizing the global nature of the Internet, you agree to</p>
                            <p>comply with all local rules and laws regarding your use of the Service, including as</p>
                            <p>it concerns online conduct and acceptable content.</p>
                            <p>Commercial Use: Unless otherwise authorized herein or in the Service, you agree</p>
                            <p>not to display, distribute, license, perform, publish, reproduce, duplicate, copy,</p>
                            <p>create derivative works from, modify, sell, resell, exploit, transfer or upload&nbsp;for any</p>
                            <p>commercial purposes, any portion of the Service, use of the Service, or access to</p>
                            <p>the Service except for your own User Content and Confidential Information (as</p>
                            <p>defined below).</p>
                            <p>Terms of Sale and Refund Policy</p>
                            <p>Once an order has been marked as &ldquo;In Progress,&rdquo; as indicated on the order status</p>
                            <p>page, the order cannot be refunded. All other refunds shall be issued at&nbsp;PGT&rsquo;s sole</p>
                            <p>discretion. All amounts required to be paid for&nbsp;PGT&nbsp;Services include no amount for</p>
                            <p>taxes or&nbsp;levy (including interest and penalties). You shall pay all applicable taxes to</p>
                            <p>relevant authorities including, without limitation, sales, use, value-added tax,</p>
                            <p>excise, property, or other similar taxes or levies. You shall be responsible for all</p>
                            <p>taxes associated with Services other than U.S. taxes based on&nbsp;PGT&apos;s net income.</p>
                            <p>Should&nbsp;PGT&nbsp;fail to provide any requested Service, your sole and exclusive remedy</p>
                            <p>shall be to have the requested Service provided as soon as commercially</p>
                            <p>reasonable, unless otherwise guaranteed or stipulated on the Site (e.g., for certain</p>
                            <p>guaranteed expedited orders). Guarantees made by&nbsp;PGT&nbsp;that appear elsewhere</p>
                            <p>on the Site are incorporated by reference into these Terms of Service.</p>
                            <p>Intellectual Property Rights and Confidentiality</p>
                            <div><br></div>
                            <p>Service Content, Software, and Trademarks: You acknowledge and agree that the</p>
                            <p>Service may contain content or features (&ldquo;Service Content&rdquo;) that are protected by</p>
                            <p>copyright, patent, trademark, trade secret or other proprietary rights and laws.</p>
                            <p>Except as authorized by&nbsp;PGT, you agree not to modify, copy, frame, scrape, rent,</p>
                            <p>lease, loan, sell, distribute, or create derivative works based on the Service or the</p>
                            <p>Service Content, in whole or in part, except that the foregoing does not apply to</p>
                            <p>your own User Content (as defined below) that you legally upload to the Service.</p>
                            <p>With your use of the Service, you agree not to engage in or use any data mining,</p>
                            <p>robots, scraping or similar data gathering or extraction methods. Any use of the</p>
                            <p>Service or the Service Content other than as&nbsp;specifically authorized is strictly</p>
                            <p>prohibited. The technology and software underlying the Service or distributed in</p>
                            <p>connection therewith is the property of&nbsp;PGT, our affiliates and our partners (the</p>
                            <p>&ldquo;Software&rdquo;). You agree not to copy, modify, create a derivative work of, reverse</p>
                            <p>engineer, reverse assemble, or otherwise attempt to discover any source code,</p>
                            <p>sell, assign, sublicense, or otherwise transfer any right in the Software. Any rights</p>
                            <p>not granted herein are reserved by&nbsp;PGT.</p>
                            <p>The&nbsp;PGT&nbsp;name and logos are&nbsp;trademarks and service marks of&nbsp;PGT&nbsp;(collectively</p>
                            <p>the &ldquo;PGT&nbsp;Trademarks&rdquo;). Other company, product, and service names and logos</p>
                            <p>used and displayed via the Service may be trademarks or service marks of their</p>
                            <p>respective owners, who may or may not endorse or be&nbsp;affiliated with or connected</p>
                            <p>to&nbsp;PGT.</p>
                            <p>With prior written permission, either&nbsp;PGT&nbsp;or you may include the other party&rsquo;s</p>
                            <p>name and logo on any customer or vendor lists, including lists publicly available</p>
                            <p>online.</p>
                            <p>You also agree to consider the following upon&nbsp;PGT&apos;s written or verbal request: (a)</p>
                            <p>issuing joint or individual press releases regarding the relationship; (b) serving as a</p>
                            <p>customer reference; or (c) creating case studies or other such written or digital</p>
                            <p>collateral. Nothing else in these Terms of Service should be construed as granting,</p>
                            <p>by implication, estoppel, or otherwise, any license or right to use any of&nbsp;PGT</p>
                            <p>Trademarks displayed on the Service, without our prior written permission in each</p>
                            <p>instance. All goodwill generated from&nbsp;PGT&nbsp;Trademarks will inure&nbsp;to our exclusive</p>
                            <p>benefit.</p>
                            <p>Third Party Material: Under no circumstances will&nbsp;PGT&nbsp;be liable for any content or</p>
                            <p>materials of any third parties (including users), including, but not limited to, for any</p>
                            <p>errors or omissions in any content, or for any loss or damage of any kind incurred</p>
                            <p>because of the use of any such content. You acknowledge that&nbsp;PGT&nbsp;does not pre-</p>
                            <p>screen content, but that&nbsp;PGT&nbsp;and its designees will have the right (but not the</p>
                            <p>obligation) in their sole discretion to refuse or remove any content available via the</p>
                            <p>Service. Without limiting the foregoing,&nbsp;PGT&nbsp;and its designees may remove any</p>
                            <p>content that violates these Terms of Service or is deemed by&nbsp;PGT, in its sole</p>
                            <p>discretion, to be otherwise objectionable. You agree that you must evaluate, and</p>
                            <p>bear all risks associated with, using any content you receive or encounter via the</p>
                            <div><br></div>
                            <p>Service, including any reliance on the accuracy, completeness, or usefulness of</p>
                            <p>such content.</p>
                            <p>User Content Transmitted Through the Service: With respect to content or other</p>
                            <p>materials you upload through the Service or share with other users or recipients</p>
                            <p>(collectively, &ldquo;User Content&rdquo;), you represent and warrant that you own (or have</p>
                            <p>sufficient rights to) all right, title, and interest in such User Content, including,</p>
                            <p>without limitation, all copyright and rights of publicity contained therein. By</p>
                            <p>uploading any User Content you grant and will grant&nbsp;PGT&nbsp;and its affiliated</p>
                            <p>companies a nonexclusive, worldwide, royalty free, fully paid up, transferable,</p>
                            <p>sublicenseable, perpetual, irrevocable license to copy, display, upload, perform,</p>
                            <p>distribute, store, modify and otherwise use your User Content in connection with</p>
                            <p>the&nbsp;operation of the Service on your behalf, in any form, medium or technology</p>
                            <p>now known or later developed.&nbsp;This provision does not apply to &ldquo;Confidential</p>
                            <p>Information&rdquo; (as described below).</p>
                            <p>You acknowledge and agree that questions, comments, suggestions, ideas,</p>
                            <p>feedback or other information about the Service (&ldquo;Submissions&rdquo;), you provide to</p>
                            <p>PGT&nbsp;are not confidential and&nbsp;PGT&nbsp;will be entitled to the unrestricted use and</p>
                            <p>dissemination of these Submissions for any purpose, commercial or otherwise,</p>
                            <p>without acknowledgment or compensation to you.</p>
                            <p>You acknowledge and agree that&nbsp;PGT&nbsp;may preserve content and may also</p>
                            <p>disclose any User Content or Submissions if required to do so by law or in the</p>
                            <p>good faith belief that such preservation or disclosure is reasonably necessary&nbsp;to:</p>
                            <p>(a) comply with legal process, applicable laws or government requests; (b) enforce</p>
                            <p>these Terms of Service; (c) respond to claims that any content violates the rights of</p>
                            <p>third parties; or (d) protect the rights, property, or personal safety of&nbsp;PGT, its&nbsp;users</p>
                            <p>and the public. You understand that the technical processing and transmission of</p>
                            <p>the Service, including your content, may involve (a) transmissions over various</p>
                            <p>networks; and (b) changes to conform and adapt to technical requirements of</p>
                            <p>connecting networks or devices. For more information about disclosure of</p>
                            <p>personally identifiable information, please see our Privacy Policy.</p>
                            <p>Confidentiality: Any content (including video, audio, and written documents) or</p>
                            <p>other text you provide to&nbsp;PGT&nbsp;so that&nbsp;PGT&nbsp;may provide the Services will be your</p>
                            <p>&ldquo;Confidential Information,&rdquo; except to the extent that such content (a) contains</p>
                            <p>information known to&nbsp;PGT&nbsp;before receipt from you through a source other than one</p>
                            <p>having an obligation of confidentiality to you; (b) contains information that becomes</p>
                            <p>known (independently of disclosure by you) to&nbsp;PGT&nbsp;directly or indirectly through a</p>
                            <p>source other than one having an obligation of confidentiality to you; or (c) contains</p>
                            <p>information that is or becomes publicly known, or otherwise ceases to be secret or</p>
                            <p>confidential, except through a breach of these Terms of Service by&nbsp;PGT.&nbsp;PGT&nbsp;will</p>
                            <p>use the Confidential Information solely to provide the Services to you (the</p>
                            <p>&ldquo;Permitted Purpose&rdquo;).&nbsp;PGT&nbsp;will not, without your prior consent, disclose to any&nbsp;third</p>
                            <p>party your Confidential Information, other than furnishing such Confidential</p>
                            <p>Information to our directors, officers, employees, agents, consultants, contractors,</p>
                            <div><br></div>
                            <p>representatives, vendors, or affiliated entities (collectively, &ldquo;Associated Persons&rdquo;)</p>
                            <p>who need to have access to such Confidential Information in connection with the</p>
                            <p>Permitted Purpose.&nbsp;PGT&nbsp;will use at least reasonable care to protect the</p>
                            <p>confidentiality of your Confidential Information. If&nbsp;PGT&nbsp;is required by law to make</p>
                            <p>any disclosure of any&nbsp;of your Confidential Information, by subpoena, judicial or</p>
                            <p>administrative order or otherwise,&nbsp;PGT&nbsp;will use commercially reasonable efforts to</p>
                            <p>give you notice of such requirement (to the extent legally permissible) and will</p>
                            <p>permit you to intervene in any proceedings to protect your interests in your</p>
                            <p>Confidential Information. For more information about our use of your Confidential</p>
                            <p>information, please see our Privacy Policy.</p>
                            <p>Copyright Complaints:&nbsp;PGT&nbsp;respects the intellectual property of others, and we ask</p>
                            <p>our users to do the same. If you believe that your work has been copied in a way</p>
                            <p>that constitutes copyright infringement, or that your intellectual property rights have</p>
                            <p>been otherwise violated, notify&nbsp;PGT&nbsp;of your infringement claim using the procedure</p>
                            <p>set forth below.</p>
                            <p>PGT&nbsp;will process and investigate notices of alleged infringement and will take</p>
                            <p>actions under the Digital Millennium Copyright Act (&ldquo;DMCA&rdquo;) and other applicable</p>
                            <p>intellectual property laws regarding any alleged or actual infringement. A</p>
                            <p>notification of claimed copyright infringement should be emailed to&nbsp;PGT&apos;s Copyright</p>
                            <p>Agent at&nbsp;info@pgt.email&nbsp;(Subject line: &ldquo;DMCA&nbsp;Takedown Request&rdquo;).</p>
                            <p>To be effective, the notification must be in writing and contain the following</p>
                            <p>information:</p>
                            <p>&bull;&nbsp;an electronic or physical signature of the person authorized to act on behalf</p>
                            <p>of the owner of the copyright or other intellectual property interest;</p>
                            <p>&bull;&nbsp;a description of the copyrighted work or other intellectual property you claim</p>
                            <p>has been infringed;</p>
                            <p>&bull;&nbsp;a description of where the material you claim is infringing is located on the</p>
                            <p>Service, with enough detail that we may find it on the Service;</p>
                            <p>&bull;&nbsp;your address, telephone number, and email address;</p>
                            <p>&bull;&nbsp;a statement by you that you have a good faith belief that the disputed use is</p>
                            <p>not authorized by the copyright or intellectual property owner, its agent, or</p>
                            <p>the law;</p>
                            <p>&bull;&nbsp;a statement by you, made under penalty of&nbsp;perjury, that the above</p>
                            <p>information in your notice is accurate and that you are the copyright or</p>
                            <p>intellectual property owner or authorized to act on the copyright or</p>
                            <p>intellectual property owner&apos;s behalf.</p>
                            <p>Counter-Notice: If you believe that your User Content that was removed (or to</p>
                            <p>which access was disabled) is not infringing, or that you have the authorization</p>
                            <p>from the copyright owner, the copyright owner&apos;s agent, or pursuant to the law, to</p>
                            <p>upload and use the content in your User Content, you may send a written counter-</p>
                            <p>notice containing the following information to the Copyright Agent:</p>
                            <div><br></div>
                            <p>&bull;&nbsp;your physical or electronic signature;</p>
                            <p>&bull;&nbsp;identification of the content that has been removed or to which access has</p>
                            <p>been disabled and the location at which the content appeared&nbsp;before it was</p>
                            <p>removed or disabled;</p>
                            <p>&bull;&nbsp;a statement that you have a good faith belief that the content was removed</p>
                            <p>or disabled because of mistake or a misidentification of the content; and</p>
                            <p>&bull;&nbsp;your name, address, telephone number, and e-mail address, a statement</p>
                            <p>that you consent to the jurisdiction of the federal court within the District of</p>
                            <p>Maryland; and</p>
                            <p>&bull;&nbsp;a statement that you will accept service of process from the person who</p>
                            <p>provided notification of the alleged infringement.</p>
                            <p>If a counter-notice is received by the Copyright Agent,&nbsp;PGT&nbsp;will send a copy of the</p>
                            <p>counter-notice to the original complaining party informing that person that it may</p>
                            <p>replace the removed content or cease disabling it in 10 business days. Unless the</p>
                            <p>copyright owner seeks a court order against the&nbsp;content provider, member or user,</p>
                            <p>the removed content may be replaced, or access to it restored, in 10 to 14</p>
                            <p>business days or more after receipt of the counter-notice, at our sole discretion.</p>
                            <p>Repeat Infringer Policy: Under the DMCA and other applicable law,&nbsp;PGT&nbsp;has</p>
                            <p>adopted a policy of terminating, in appropriate circumstances and at&nbsp;PGT&rsquo;s sole</p>
                            <p>discretion, users deemed to be repeat infringers.&nbsp;PGT&nbsp;may also at its sole</p>
                            <p>discretion limit access to the Service and/or terminate the memberships of any</p>
                            <p>users who infringe any intellectual property rights of others, whether or not there is</p>
                            <p>any repeat infringement.</p>
                            <p>Third Party Websites</p>
                            <p>The Service may provide, or third parties may provide, links or other access to</p>
                            <p>other sites and resources on the Internet.&nbsp;PGT&nbsp;has no control over such sites and</p>
                            <p>resources and&nbsp;PGT&nbsp;is not responsible for and does not endorse such sites and</p>
                            <p>resources. You acknowledge and agree that&nbsp;PGT&nbsp;will not be responsible or liable,</p>
                            <p>directly or indirectly, for any damage or loss caused or alleged to be caused by or</p>
                            <p>in connection with use of or reliance on any content, events, goods or services</p>
                            <p>available on or through any&nbsp;such site or resource. Any dealings you have with third</p>
                            <p>parties found while using the Service are between you and the third party, and you</p>
                            <p>agree that&nbsp;PGT&nbsp;is not liable for any loss or claim that you may have against any</p>
                            <p>such third party.</p>
                            <p>Indemnity and Release</p>
                            <p>You agree to release, indemnify and hold&nbsp;PGT&nbsp;and its affiliates and their officers,</p>
                            <p>employees, directors and agent harmless from any and all losses, damages,</p>
                            <p>expenses, including reasonable attorneys&apos; fees, rights, claims, actions of any kind</p>
                            <p>and injury&nbsp;(including death) arising out of or relating to your use of the Service, any</p>
                            <p>User Content, your connection to the Service, your violation of these Terms of</p>
                            <p>Service or your violation of any rights of another. If you are a California resident,</p>
                            <div><br></div>
                            <p>you waive California Civil Code Section 1542, which says: &ldquo;A general release does</p>
                            <p>not extend to claims which the creditor does not know or suspect to exist in his</p>
                            <p>favor at the time of executing the release, which if known by him must have</p>
                            <p>materially affected his settlement with the debtor.&rdquo; If you are a resident of another</p>
                            <p>jurisdiction, you waive any comparable statute or doctrine.</p>
                            <p>Disclaimer of Warranties</p>
                            <p>YOUR USE OF THE SERVICE IS AT YOUR SOLE RISK. THE SERVICE IS</p>
                            <p>PROVIDED ON AN &ldquo;AS IS&rdquo; AND &ldquo;AS AVAILABLE&rdquo; BASIS, EXCEPT WHERE</p>
                            <p>EXPLICITLY GUARANTEED OTHERWISE BY&nbsp;PGT.&nbsp;PGT&nbsp;EXPRESSLY</p>
                            <p>DISCLAIMS ALL WARRANTIES OF ANY KIND, WHETHER EXPRESS, IMPLIED</p>
                            <p>OR STATUTORY, INCLUDING, BUT NOT LIMITED TO THE IMPLIED</p>
                            <p>WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR</p>
                            <p>PURPOSE, TITLE AND&nbsp;NON-INFRINGEMENT.</p>
                            <p>PGT&nbsp;MAKES NO WARRANTY THAT (I) THE SERVICE WILL MEET YOUR</p>
                            <p>REQUIREMENTS, (II) THE SERVICE WILL BE UNINTERRUPTED, TIMELY,</p>
                            <p>SECURE, OR ERROR-FREE, (III) THE RESULTS THAT MAY BE OBTAINED</p>
                            <p>FROM THE USE OF THE SERVICE WILL BE ACCURATE OR RELIABLE, OR</p>
                            <p>(IV) THE QUALITY OF ANY DOCUMENTS, PRODUCTS, SERVICES,</p>
                            <p>INFORMATION, OR OTHER MATERIAL PURCHASED OR OBTAINED BY YOU</p>
                            <p>THROUGH THE SERVICE WILL MEET YOUR EXPECTATIONS.</p>
                            <p>Limitation of Liability</p>
                            <p>YOU EXPRESSLY UNDERSTAND AND AGREE THAT&nbsp;PGT&nbsp;WILL NOT BE</p>
                            <p>LIABLE&nbsp;FOR ANY INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL,</p>
                            <p>EXEMPLARY DAMAGES, OR DAMAGES FOR LOSS OF PROFITS INCLUDING</p>
                            <p>BUT NOT LIMITED TO, DAMAGES FOR LOSS OF GOODWILL, USE, DATA OR</p>
                            <p>OTHER INTANGIBLE LOSSES (EVEN IF&nbsp;PGT&nbsp;HAS BEEN ADVISED OF THE</p>
                            <p>POSSIBILITY OF SUCH DAMAGES), WHETHER BASED ON CONTRACT,</p>
                            <p>TORT, NEGLIGENCE, STRICT LIABILITY OR OTHERWISE, RESULTING FROM:</p>
                            <p>(I) THE USE OR THE INABILITY TO USE THE SERVICE; (II) THE COST OF</p>
                            <p>PROCUREMENT OF SUBSTITUTE GOODS AND SERVICES RESULTING</p>
                            <p>FROM ANY GOODS, DATA, INFORMATION OR SERVICES PURCHASED OR</p>
                            <p>OBTAINED OR MESSAGES RECEIVED OR TRANSACTIONS ENTERED INTO</p>
                            <p>THROUGH OR FROM THE SERVICE; (III) UNAUTHORIZED ACCESS TO OR</p>
                            <p>ALTERATION OF YOUR TRANSMISSIONS OR DATA; (IV) STATEMENTS OR</p>
                            <p>CONDUCT OF ANY THIRD PARTY ON THE SERVICE; OR (V) ANY OTHER</p>
                            <p>MATTER RELATING TO THE SERVICE. IN NO EVENT WILL&nbsp;PGT&apos;S TOTAL</p>
                            <p>LIABILITY TO YOU FOR ALL DAMAGES, LOSSES OR CAUSES OF ACTION</p>
                            <p>EXCEED THE AMOUNT YOU HAVE PAID&nbsp;PGT&nbsp;IN THE LAST SIX (6) MONTHS,</p>
                            <p>OR, IF GREATER, ONE HUNDRED DOLLARS ($100).</p>
                            <p>SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF CERTAIN</p>
                            <p>WARRANTIES OR THE LIMITATION OR EXCLUSION OF LIABILITY FOR</p>
                            <div><br></div>
                            <p>INCIDENTAL OR CONSEQUENTIAL DAMAGES. ACCORDINGLY, SOME OF</p>
                            <p>THE ABOVE LIMITATIONS SET FORTH ABOVE MAY NOT APPLY TO YOU. IF</p>
                            <p>YOU ARE DISSATISFIED WITH ANY PORTION OF THE SERVICE OR WITH</p>
                            <p>THESE TERMS OF SERVICE, YOUR SOLE AND EXCLUSIVE REMEDY IS TO</p>
                            <p>DISCONTINUE USE OF THE SERVICE.</p>
                            <p>DISPUTES, CHOICE OF LAW, AND FORUM</p>
                            <p>Agreement to Binding Arbitration</p>
                            <p>You understand and agree that any dispute, claim, or controversy arising out of or</p>
                            <p>relating to these Terms of Service, the parties&rsquo; relationship with each other and/or</p>
                            <p>your access to and/or use of any&nbsp;PGT&nbsp;Service, including, but not limited to any</p>
                            <p>claim or&nbsp;controversy as to arbitrability (&ldquo;Dispute&rdquo;), shall be finally and exclusively</p>
                            <p>settled by arbitration, provided that, nothing in this clause shall bar a party from</p>
                            <p>seeking injunctive relief in emergent circumstances, including but not limited to the</p>
                            <p>dissemination of its intellectual property.</p>
                            <p>Such arbitration shall be administered by the American Arbitration Association</p>
                            <p>(&ldquo;AAA&rdquo;) under AAA&rsquo;s Commercial Arbitration Rules and Mediation Procedures and</p>
                            <p>Consumer-Related Disputes Supplementary Procedures, excluding&nbsp;any rules or</p>
                            <p>procedures governing or permitting class actions. No Dispute shall be settled or</p>
                            <p>litigated by a lawsuit or resort to court process, except as Maryland or any other</p>
                            <p>applicable state law provides for judicial review of arbitration proceedings.</p>
                            <p>The arbitrator, and not any federal, state or local court or agency, shall have</p>
                            <p>exclusive authority to resolve disputes arising out of or relating to the interpretation,</p>
                            <p>applicability, enforceability or formation of this agreement to arbitrate, including,&nbsp;but</p>
                            <p>not limited to any claim that all or any part of this agreement is void or voidable.</p>
                            <p>The parties agree to treat the arbitration proceedings and any related discovery as</p>
                            <p>confidential. The terms of this Agreement to Binding Arbitration govern if they</p>
                            <p>conflict with the rules of the AAA.</p>
                            <p>You agree that any arbitration shall be conducted in Anne Arundel County,</p>
                            <p>Maryland. The arbitrator shall be selected under the AAA rules. Should no AAA</p>
                            <p>rule regarding Maryland selection of an arbitrator be in effect, you shall select an</p>
                            <p>arbitrator from a panel of arbitrators acceptable to&nbsp;PGT. In any arbitration, the</p>
                            <p>parties will split the cost of the filing fee, plus the costs associated with the first day</p>
                            <p>of arbitration, with the remaining costs of arbitration paid by the&nbsp;non-prevailing</p>
                            <p>party, provided, however, that in some jurisdictions such as Maine, to the extent</p>
                            <p>required by law, any cost to the consumer shall be limited. To begin the arbitration</p>
                            <p>process, a party must make a written demand for arbitration.</p>
                            <p>Class Action&nbsp;and Class Arbitration Waiver</p>
                            <p>The parties further agree that any arbitration shall be conducted in their individual</p>
                            <p>capacities only and not as a class action or other representative action, and the</p>
                        </div>
                        <br>
                        <div class="fieldset-content">

                            <div class="form-row">
                                <label for="accept" class="option" style="    margin-top: 20px; display: block;">
                                    <input required type="checkbox" id="accept" name="Terms" value="1">
                                  <?=_("ACEPTO TÉRMINOS Y CONDICIONES")?>
                                </label>
                            </div>
                        </div>
                    </fieldset>

                    <h3><?=_("Confirmación y pago")?></h3>
                    <fieldset>
                        <h2><?=_("Pago y confirmación de orden")?></h2>
                        <div class="fieldset-content">
                            <div class="form-card">

                                <div class="row">
                                    <div class="col-md-12" id="totals2">

                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </form>
        </div>
        <div id="summary">
            <h3><?=_("Resumen de la orden")?></h3>
            <hr>
            <div id="summary-content"></div>

        </div>
    </div>

    <div class="msg-form" id="success-msg">
        <div>
            <img src="snippets/logo_en.png" alt="" width="150">
            <h2><?=_("¡Excelente!")?></h2>
            <hr>
            <h4><?=_("Tu solicitud ha sido enviada correctamente, nos pondremos en contacto contigo; puedes revisar tu bandeja de entrada de email para ingresar a nuestro administrador donde puedes ver el progreso de tu proyecto y crear nuevas cotizaciones, revisa tu correo electrónico para validar tu acceso")?></h4>
            <a href="index.php">
                <button type="button" class="btn btn-primary" style="display: inline-block;">
                  <?=_("Realizar otra cotización")?>
                </button>
            </a>
             <?php 
            if(!isset($no_redeclare)){
                ?>
                <a href="../client/index.php">
                <button type="button" class="btn btn-primary" style="display: inline-block;">
                  <?=_("Acceso cliente")?>
                </button>
            </a>
                <?php
            }
            ?>
        </div>
    </div>

    <div class="msg-form" id="error-msg">
        <div>
            <img src="snippets/logo_en.png" alt="" width="150">
            <h2><?=_("Lo sentimos...")?></h2>
            <hr>
            <h4 style="color:red" id="errorapi"></h4>
            <h4><?=_("Tu solicitud no se pudo procesar, por favor intenta de nuevo, revisa todos los campos, y añade al menos un archivo a esta solicitud sino tu solicitud no será procesada. Si no logras enviar la cotización,")?>
                <a href="mailto:help@precisetranslations.com"><?=_("contáctanos")?></a> <?=_("y con gusto te atenderemos")?></h4>
            <button type="button" class="btn btn-primary" style="margin: auto" onclick="resetMe()">
              <?=_("Reintentar")?>
            </button>
        </div>
    </div>

</div>

<!-- JS -->
<script src="<?=$base?>vendor/jquery/jquery.min.js"></script>
<script src="<?=$base?>vendor/jquery-validation/dist/jquery.validate.min.js"></script>
<script src="<?=$base?>vendor/jquery-validation/dist/additional-methods.min.js"></script>
<script src="<?=$base?>vendor/jquery-steps/jquery.steps.min.js"></script>
<script src="<?=$base?>vendor/minimalist-picker/dobpicker.js"></script>
<script src="<?=$base?>vendor/nouislider/nouislider.min.js"></script>
<script src="<?=$base?>vendor/wnumb/wNumb.js"></script>
<script src="<?=$base?>js/main.js"></script>
<script src="https://unpkg.com/dropzone@5.9.3/dist/min/dropzone.min.js"></script>
<link rel="stylesheet" href="https://unpkg.com/dropzone@5.9.3/dist/min/dropzone.min.css" type="text/css" />


<script src="https://code.jquery.com/jquery-2.2.4.js" integrity="sha256-iT6Q9iMJYuQiMWNd9lDyBUStIq/8PuOW33aOqmvFpqI=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js"></script>


<script>
    function resetMe(){
        $("#success-msg").hide();
        $("#error-msg").hide();
        $("#wrapper-form").show();
    }
    
    function getTotals(){
        $.post("<?=$base?>actions/totals.php").done(function(response){
            $("#totals2").html(response);
        });
    }

    function getSummary(){
        $(window).scrollTop(0);
        saveAll();
        $.post("<?=$base?>actions/summary.php").done(function(response){
            $("#summary-content").html(response);
        });
        /**/
    }

    function uploadFileNow(fileInput){
        event.preventDefault();
        var file_data = $(fileInput).prop('files')[0];
        var form_data = new FormData();
        form_data.append('file', file_data);
        $.LoadingOverlay("show");

        $.ajax({
            url: '<?=$base?>actions/upload-file.php', // point to server-side PHP script
            dataType: 'text',  // what to expect back from the PHP script, if anything
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,
            type: 'post',
            success: function(response){
                $.LoadingOverlay("hide");

                response = JSON.parse(response);
                if(response.type=="success"){
                    addFileRow(response);
                }
            }
        });
    }
</script>
<?php
if(!isset($no_redeclare)){
  ?>
    <style>
        *{
            font-family: Verdana, Geneva, sans-serif;
        }
        input, button{
            font-family: Verdana, Geneva, sans-serif !important;
        }

        footer{
            position: fixed;
            bottom: 0;
            color: white;
            text-align: center;
            width: 100%;
            z-index: 99;
        }
    </style>
    <footer>
      <?=_("Todos los derechos reservados Precise Translations")?>
    </footer>
  <?php
}

?>
<script src="https://www.paypal.com/sdk/js?client-id=test&currency=USD&intent=capture"></script>

<?php
if(isset($_GET["salt"])){
    $abandoned = new Abandoned();
    $abandoned->Salt = $_GET["salt"];
    $data = $abandoned->GetBySalt();
    $data = $data["FullData"];
    ?>
    <script>
        var data = <?=$data?>;

        for(key in data)
        {
            if(data.hasOwnProperty(key))
                $('input[name='+key+']').val(data[key]);
        }
    </script>
<?php
}
?>

<script>
document.addEventListener("DOMContentLoaded", function(event) { 
  $(window).bind("pageshow", function() {
    var form = $('form'); 
    // let the browser natively reset defaults
    form[0].reset();
});
});

    document.getElementById('phone').addEventListener('input', function (e) {
        var x = e.target.value.replace(/\D/g, '').match(/(\d{0,3})(\d{0,3})(\d{0,4})/);
        e.target.value = !x[2] ? x[1] : '(' + x[1] + ') ' + x[2] + (x[3] ? '-' + x[3] : '');
    });
</script>

</body>

</html>
