<?php

session_start();
require("../../core/utils/Utils.php");
require("validation.php");
$utils = new Utils();
$num = count(glob("../../uploads/tmp/".$utils->ReturnSessionVar("tmp")."/" . "*"));

if(!function_exists("_")){
  function _($text){
    return $text;
  }
}

$current = json_decode($_SESSION["order"], true);
?>
<div class="card">
    <h4><?=_("Cliente")?></h4>
    <p><?=$current["client"]?></p>
</div>
<div class="card">
    <h4><?=_("Tipo de traducción")?></h4>
    <p><?=($current["type"]=="1"?_("Traducción certificada"):_("Traducción estándar"))?></p>
</div>
<?php
if($num>0){
  ?>
    <div class="card">
        <h4><?=_("Total archivos a traducir")?></h4>
        <p><?=$num?></p>
    </div>
<?php
}
?>
<?php
if($current["only-quote"]==false){
    if($current["total-words"]!=""){
        $total = get_pages_total($utils->ReturnSessionVar("tmp"));
         ?>
        <div class="card">
            <h4><?=_("Total de páginas")?></h4>
            <p><?=$current["total-words"]?></p>
        </div>
        <div class="card">
            <h4><?=_("Total de páginas detectadas en sistema")?></h4>
            <p><?=$total?></p>
        </div>
        <div class="card">
            <h4><?=_("Costo por página")?></h4>
            <p><?=$current["word"]?></p>
        </div>
      <?php
      if($total!=$current["total-words"]){
          $current["only-quote"] = true;
          $_SESSION["order"] = json_encode($current);
          ?>
          <style>
              .card.alert.alert-warning {
                background: #232f60;
                padding: 10px;
                font-size: smaller;
                color: white;
            }
          </style>
          <div class="card alert alert-warning">
            <strong><?=_("La cantidad de páginas que proporcionaste es diferente a las que nuestro sistema ha detectado, verifica tu información o continúa el proceso para enviar a cotización")?></strong>
        </div>
          <?php
      }else{
          $current["only-quote"] = false;
          $_SESSION["order"] = json_encode($current);
      }
    }

}

if($current["addon"]!=""){
    ?>
    <div class="card">
        <h4><?=_("Adicional")?></h4>
        <p><?=$current["addon"]?></p>
    </div>
<?php
}
?>
<?php
if($current["delivery"]!=""){
  ?>
    <div class="card">
        <h4><?=_("Forma de entrega")?></h4>
        <p><?=$current["delivery"]?></p>
    </div>
  <?php
}
if($current["only-quote"]==false){
?>
    <div class="card">
        <h4><?=_("Total estimado")?></h4>
        <p>$<?=number_format($current["total"],2 )?> USD</p>
    </div>
    <script>
        var totalPayment = "<?=$current["total"]?>";
    </script>
<?php
}else{
    ?>
  <div class="alert alert-info">
      <?=_("Tu traducción especializada necesita ser cotizada, envía este formulario y te daremos una respuesta pronto")?>
  </div>
<?php
}
