<?php
class NotificationMessage {
    private $title = array(
        "new_client" => array("Nuevo cliente registrado","A new client has registered in the application"),
        "new_ad" => array("Nuevo anuncio publicitario a evaluar",""),
        "new_eval_coupon" => array("Nuevo cupón a ser evaluado","New coupon to evaluate"),
        "new_eval_advertising" => array("Nuevo anuncio a ser evaluado","New advertising to evaluate"),
        "new_winner" => array("Ha surgido un ganador del cupón de 100 USD",""),
        "edited_coupon" => array("Cupón editado",""),
        "new_coupon_status" => array("Un cupón ha cambiado de estado","A coupon changed its status"),
        "new_advertising_status" => array("Un anuncio ha cambiado de estado","An advertising banner changed its status"),
        "new_comment_from_admin" => array("Nuevo comentario del administrador","New comment from administrator"),
        "new_comment_from_client" => array("Nuevo comentario de cliente en cupón/banner","New comment from client in coupon/banner"),
        "new_subscription" => array("Nuevo pago de plan","New plan payment"),

    );
    private $alert = array(
        "new_client" => array("Un nuevo cliente se ha registrado",""),
        "new_eval_coupon" => array("",""),
        "new_coupon_status" => array("",""),
        "new_comment_from_client" => array("",""),
        "" => array("",""),
        "" => array("",""),
        "" => array("",""),
        "" => array("",""),
    );

    private $icon = array(
        "new_client" => 'btn-success fa fa-user',
        "new_eval_coupon" => 'btn-danger fa fa-check',
        "new_coupon_status" => 'btn-warning fa fa-refresh',
        "new_comment_from_client" => 'btn-pink fa fa-comment',
        "new_comment_from_admin" => 'btn-pink fa fa-comment',
        "new_subscription" => 'btn-success fa fa-usd',
        "new_eval_advertising" => 'btn-success fa fa-picture-o',
        "new_advertising_status" => 'btn-warning fa fa-refresh',
        "" => array("",""),
    );

    public function GetNotification($key, $lang){
        $json = array("title" =>$this->title[$key][$lang],"content" =>$this->alert[$key][$lang] );
        return json_encode($json);
    }

    public function GetTitleNotification($key, $lang){
        return $this->title[$key][$lang];
    }

    public function GetContentNotification($key, $lang){
        return $this->alert[$key][$lang];
    }

    public function GetIcon($key){
        return $this->icon[$key];
    }
}