/**
 * @return {null}
 */




function JSON_parser(target){
    try{
        return JSON.parse(target);
    }catch (e){
        toastr.error("Error desconocido, contacte a soporte");
        return null;
    }
}


function ClearValidations(form_target){
    validation = $("#"+form_target).find(".validation");
    $(validation).empty();
    $("#"+form_target+" *").removeClass("incorrect");
}

function AddErrors(array, form_target){
    if(array.Errors!=undefined){
        errors = array.Errors;
        validations=array.Validations;
        validation = $("#"+form_target).find(".validation");
        ClearValidations(form_target);
        for(i=0;i<errors.length;i++){
            $("#"+form_target+" *[name="+errors[i]+"]").addClass("incorrect");
        }
        for(i=0;i<validations.length;i++){
            $(validation).append("<p class='validation-error'><i class='fa fa-arrow-right'></i>"+validations[i]+"</p>");
        }
    }

}

function SimpleAlert(setting){
    if(setting!=null){
        $.alert({
            title: setting.title,
            content: setting.content,
            theme: 'material',
            confirmButton: 'Ok',
            onOpen: function(){
                this.$title.parent().parent().find(".title-c").addClass("title-"+setting.type);
            }
        });
    }
}

function AdvancedAlert(setting, handler_function){
    if(setting!=null) {
        $.alert({
            title: setting.title,
            content: setting.content,
            theme: 'material',
            confirmButton: 'Ok',
            onOpen: function(){
                this.$title.parent().parent().find(".title-c").addClass("title-"+setting.type);
            },
            confirm: function () {
                handler_function();
            }
        });
    }
}

function ConfirmationAlert(handler_function){
    var tit = "Confirme acción";
    var cont = "¿Está seguro de realizar esta operación? Si es así, da clic en Sí, de otra forma, da clic en No";
    var conf = "Sí, adelante";
    var cancel = "No, cancelar";
    $.confirm({
        title: tit,
        content: cont,
        theme: 'material',
        confirmButton: conf,
        cancelButton: cancel,
        onOpen: function(){
            this.$title.parent().parent().find(".title-c").addClass("title-quest");
        },
        confirm: function () {
            handler_function();
        }
    });
}

function AdvancedConfirmationAlert(title, content, handler_function){
    yes = "Sí, adelante";
    no = "No, cancela";
    $.confirm({
        title: title,
        content: content,
        theme: 'material',
        confirmButton: yes,
        cancelButton: no,
        onOpen: function(){
            this.$title.parent().parent().find(".title-c").addClass("title-quest");
        },
        confirm: function () {
            handler_function();
        }
    });
}

function DeleteAlert(url, target, handler_function){
    var tit = "Are you sure?";
    var cont = "You will loss all related information.";
    var conf = "Yes, continue";
    var cancel = "Cancel";
    $.confirm({
        title: tit,
        content: cont,
        theme: 'material',
        confirmButton: conf,
        cancelButton: cancel,
        onOpen: function(){
            this.$title.parent().parent().find(".title-c").addClass("title-quest");
        },
        confirm: function () {
            $.post(url,{Id : target}).done(function(response){
                //if has alert display it!
                try{
                    alerts = JSON.parse(response);
                    if(alerts!=null){
                        AdvancedAlert(alerts, handler_function);
                    }else{
                        handler_function();
                    }
                }catch (e){
                    alert = null;
                    handler_function();
                }

            });
        }
    });
}



function UpdateEditorHtml(){
    for (var i in CKEDITOR.instances) {
        CKEDITOR.instances[i].updateElement();
    }
}

function ClearEditorHtml(){
    for (var i in CKEDITOR.instances) {
        CKEDITOR.instances[i].setData("");
        CKEDITOR.instances[i].updateElement();
    }
}

function LoadFiler(filer){
    $("#"+filer).filer({
        limit: null,
        maxSize: null,
        extensions: null,
        showThumbs: false,
        captions: {
            button: "Subir imagen",
            feedback: "Seleccione su imagen",
            feedback2: "imagen seleccionada, da clic en guardar",
            drop: "Arrastre los archivos aquí",
            removeConfirmation: "¿Seguro que deseas remover este archivo?",
            errors: {
                filesLimit: "Sólo {{fi-limit}} archivos están permitidos para ser subidos",
                filesType: "Sólo imágenes permitidas",
                filesSize: "{{fi-name}} es demasiado grande, suba un archivo menor a {{fi-maxSize}} MB.",
                filesSizeAll: "Los archivos que quiere subir son demasiado grandes, por favor suba archivos menores a {{fi-maxSize}} MB."
            }
        }
    });
}

function LoadAdvancedFiler(filer){
    $("#"+filer).filer({
        limit: null,
        maxSize: null,
        extensions: null,
        showThumbs: true,
        files: null,
        addMore: true,
        clipBoardPaste: true,
        captions: {
            button: "Cargar",
            feedback: "Seleccione archivo(s)",
            feedback2: "Archivo(s) cargado(s)",
            drop: "Arrastre los archivos aquí",
            removeConfirmation: "¿Seguro que deseas remover este archivo?",
            errors: {
                filesLimit: "Sólo {{fi-limit}} archivos están permitidos para ser subidos",
                filesType: "Sólo imágenes permitidas",
                filesSize: "{{fi-name}} es demasiado grande, suba un archivo menor a {{fi-maxSize}} MB.",
                filesSizeAll: "Los archivos que quiere subir son demasiado grandes, por favor suba archivos menores a {{fi-maxSize}} MB."
            }
        }
    });

}


function AutomaticAssignment(data, form){
    $.each(data, function(i, item) {
        $("#"+form+" *[name="+i+"]").val(data[i]).trigger("change");
    })
}

function alert_image_upload_error(){
    $.alert({
        title: "Error al subir imagen",
        content: "Procure que la imagen pese menos de 5 Mb y tenga extensión jpg, png",
        theme: 'material',
        confirmButton: 'Ok',
        onOpen: function(){
            this.$title.parent().parent().find(".title-c").addClass("title-error");
        }
    });
}