<?php
require_once("snippets/autoload.php");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="snippets/logo_en.png" type="image/x-icon">
    <link rel="shortcut icon" href="snippets/logo_en.png" type="image/x-icon">
    <title><?=_("Precise translations application")?></title>
    <!-- Google font-->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap" rel="stylesheet">
    <!-- Font Awesome-->
    <link rel="stylesheet" type="text/css" href="../assets/css/fontawesome.css">
    <!-- ico-font-->
    <link rel="stylesheet" type="text/css" href="../assets/css/icofont.css">
    <!-- Themify icon-->
    <link rel="stylesheet" type="text/css" href="../assets/css/themify.css">
    <!-- Flag icon-->
    <link rel="stylesheet" type="text/css" href="../assets/css/flag-icon.css">
    <!-- Feather icon-->
    <link rel="stylesheet" type="text/css" href="../assets/css/feather-icon.css">
    <!-- Plugins css start-->
    <!-- Plugins css Ends-->
    <!-- Bootstrap css-->
    <link rel="stylesheet" type="text/css" href="../assets/css/bootstrap.css">
    <!-- App css-->
    <link rel="stylesheet" type="text/css" href="../assets/css/style.css">
    <link id="color" rel="stylesheet" href="../assets/css/color-1.css" media="screen">
    <!-- Responsive css-->
    <link rel="stylesheet" type="text/css" href="../assets/css/responsive.css">
</head>
<body>
<!-- Loader starts-->
<div class="loader-wrapper">
    <div class="theme-loader">
        <div class="loader-p"></div>
    </div>
</div>
<!-- Loader ends-->
<!-- page-wrapper Start-->
<section>
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-7"><img class="bg-img-cover bg-center" src="snippets/background.png" alt="looginpage"></div>
            <div class="col-xl-5 p-0">
                <div class="login-card">
                    <form id="login-form" class="theme-form login-form">
                        <center>
                            <img src="snippets/logo_en.png" width="50%">
                        </center>
                        <hr>
                        <h4><?=_("Login")?></h4>
                        <h6><?=_("Provide your login information")?></h6>
                        <div class="form-group">
                            <label><?=_("Email")?></label>
                            <div class="input-group"><span class="input-group-text"><i class="icon-email"></i></span>
                                <input name="Email" class="form-control" type="email" required="" >
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?=_("Password")?></label>
                            <div class="input-group"><span class="input-group-text"><i class="icon-lock"></i></span>
                                <input class="form-control" type="password" name="Password" required="" >

                            </div>
                        </div>
                        <div class="form-group">
                            <button class="btn btn-primary" style="background: #1f2e61 !important; border: 1px solid #1f2e61 !important;" type="submit"><?=_("Login")?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
if(isset($_GET["token"])){
    $user = new UserAccount();
    $user->Token = $utils->SanitizeString($_GET["token"]);
    $data = $user->GetRecordByToken();
    if(count($data)>0){
        ?>
        <div class="modal fade" id="token-modal" tabindex="-1" role="dialog" aria-labelledby="main-modal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?=_("Welcome")?>!</h5>
                        <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?=$data["FullName"]?>, <?=_("to start using our application, please provide your password with a minimum of 7 characters")?> </p>
                        <form id="token-form" class="theme-form">
                            <input type="hidden" name="Token" value="<?=$user->Token?>">
                            <div class="form-group">
                                <label><?=_("Write a new password")?></label>
                                <div class="input-group"><span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input class="form-control" type="password" name="Password" required="" >

                                </div>
                            </div>
                            <div class="form-group">
                                <label><?=_("Rewrite your password to confirm")?></label>
                                <div class="input-group"><span class="input-group-text"><i class="icon-lock"></i></span>
                                    <input class="form-control" type="password" name="Password2" required="" >

                                </div>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-primary" style="background: #1f2e61 !important; border: 1px solid #1f2e61 !important;" type="submit"><?=_("Save & enter")?></button>
                                <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?=_("Close")?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
      <?php
    }
}
?>



<!-- page-wrapper end-->
<!-- latest jquery-->
<script src="../assets/js/jquery-3.5.1.min.js"></script>
<!-- feather icon js-->
<script src="../assets/js/icons/feather-icon/feather.min.js"></script>
<script src="../assets/js/icons/feather-icon/feather-icon.js"></script>
<!-- Sidebar jquery-->
<script src="../assets/js/sidebar-menu.js"></script>
<script src="../assets/js/config.js"></script>
<!-- Bootstrap js-->
<script src="../assets/js/bootstrap/popper.min.js"></script>
<script src="../assets/js/bootstrap/bootstrap.min.js"></script>
<!-- Plugins JS start-->
<!-- Plugins JS Ends-->
<!-- Theme js-->
<script src="../assets/js/script.js"></script>
<!-- login js-->
<!-- Plugin used-->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        $("#login-form").submit(function(event){
            event.preventDefault();
            $.post("actions/login.php", $(this).serialize()).done(function(result){
                if(result == "success"){
                    location.href="index.php";
                }else{
                    alert("Error in access, please, try again")
                }
            });
        });
      <?php
      if(count($data)){
      ?>
        $("#token-modal").modal("show");
        $("#token-form").submit(function(event){
            event.preventDefault();
            $.post("actions/update-password-token.php", $(this).serialize()).done(function(result){
                result = JSON.parse(result);
                if(result.type == "success"){
                    location.href="index.php";
                }else{
                    alert(result.content)
                }
            });
        });
      <?php
      }

      ?>
    });





</script>
</body>
</html>