<?php
require("../snippets/autoload.php");

$entity = new UserAccount();

$rules = array();

$exclude = array();

SanitizeRequest($rules, $exclude);

$entity->Password = $_POST["Password"];
$entity->Token = $_POST["Token"];
$info = $entity->GetRecordByToken();
if(count($info)==0){
  $response_request["type"] = "error";
  $response_request["title"] = _("Error presented");
  $response_request["content"] = _("There's no linked account with that token");
}else{
  if( strlen($entity->Password)<7 || $entity->Password!=$_POST["Password2"]){
    $response_request["type"] = "error";
    $response_request["title"] = _("Error presented");
    $response_request["content"] = _("Password must have at least 7 chars and must match with confirmation");
  }else{
    $entity->Id = $info["Id"];
    $entity->Password = $utils->EncryptWithoutReverse($entity->Password);
    if($entity->UpdatePassword()){
      $response_request["type"] = "success";
      $response_request["title"] = _("Successful process");
      $response_request["content"] = _("Your password was updated");
      $entity->Token = $utils->GenerateLongString(30);
      $entity->UpdateToken();

      $utils->SetSessionVar("LOGGED-USER",$entity->Id);
      $utils->SetSessionVar("PROFILE",2);

    }else{
      $response_request["type"] = "error";
      $response_request["title"] = _("Error presented");
      $response_request["content"] = _("There was an error trying to update your password!");
    }
  }
}
echo json_encode($response_request);