<?php
require_once("snippets/autoload.php");
checkLogin();
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-sm-12">
                          <div class="card">
                              <div class="card-header pb-1">
                                  <h5>
                                      <?=_("My account")?>
                                  </h5>
                              </div>
                              <div class="card-body">
                                  <div class="row">
                                      <div class="col-sm-12">
                                        <?php
                                        $user = new UserAccount();
                                        $user->Id = $LoggedUser;
                                        $data1 = $user->GetRecord();
                                        ?>
                                          <div class="row">
                                              <div class="col-md-6">
                                                  <div class="card">
                                                      <div class="card-body">
                                                          <h5><?=_("Edit your information")?></h5>
                                                          <hr>
                                                          <form id="personal-form">
                                                              <div class="m-widget1">
                                                                  <div class="validation"></div>
                                                                  <input type="hidden" name="Id">
                                                                  <div class="form-group ">
                                                                      <strong><?=_("Full Name")?></strong>
                                                                      <input class="form-control" type="text" name="FullName" value="<?=$data1["FullName"]?>">
                                                                  </div>
                                                                  <div class="form-group">
                                                                      <strong><?=_("Email")?></strong>
                                                                      <input class="form-control m-input" type="email" name="Email" value="<?=$data1["Email"]?>">
                                                                  </div>
                                                                  <div class="form-group">
                                                                      <strong><?=_("Phone")?></strong>
                                                                      <input class="form-control m-input" type="tel" name="Phone" value="<?=$data1["Phone"]?>">
                                                                  </div>
                                                              </div>
                                                              <div class="m-widget29">
                                                                  <hr>
                                                                  <center>
                                                                      <button class="btn btn-primary btn-lg"><?=_("Save")?></button>
                                                                  </center>
                                                              </div>
                                                          </form>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="col-md-6">
                                                  <div class="card">
                                                      <div class="card-body">
                                                          <h5><?=_("Change password")?></h5>
                                                          <hr>
                                                          <form id="password-form">
                                                              <div class="m-widget1">
                                                                  <div class="validation"></div>
                                                                  <input type="hidden" name="Id">
                                                                  <div class="form-group ">
                                                                      <strong><?=_("New password")?></strong>
                                                                      <input class="form-control" type="password" name="Password">
                                                                  </div>
                                                                  <div class="form-group ">
                                                                      <strong><?=_("Confirm your password")?></strong>
                                                                      <input class="form-control" type="password" name="Confirmation">
                                                                  </div>
                                                              </div>
                                                              <div class="m-widget29">
                                                                  <hr>
                                                                  <center>
                                                                      <button class="btn btn-primary btn-lg"><?=_("Save")?></button>
                                                                  </center>
                                                              </div>
                                                          </form>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Container-fluid Ends-->
          </div>

          <?php require_once("snippets/footer.php") ?>
          <script>
              document.addEventListener('DOMContentLoaded', function() {
                  $("#password-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-password.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "error"){
                                      AddErrors(result, "password-form");
                                  }else{
                                      location.reload();
                                  }
                              });
                          }
                      });
                  });


                  $("#personal-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-my-information.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "error"){
                                      AddErrors(result, "personal-form");
                                  }
                              });
                          }
                      });
                  });


              });

          </script>
      </div>
    </div>
  </body>
</html>