<?php
require_once("snippets/autoload.php");
checkLogin();
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-sm-12">
                          <div class="card">
                              <div class="card-header pb-1">
                                  <div style="float: right" onclick="addEntity()" class="btn btn-primary ms-2"><i data-feather="user-plus">   </i> Add client  </div>

                                  <h5>
                                      <?=_("External users")?>
                                  </h5>

                              </div>
                              <div class="card-body">
                                  <div class="row">
                                      <div class="col-xs-12">
                                          <?php
                                          $entity = new UserAccount();
                                          $list = $entity->GetRecords(0);
                                          ?>
                                          <table class="table table-bordered table-striped datatable">
                                              <thead>
                                              <tr>
                                                  <th><?=_("ID")?></th>
                                                  <th><?=_("Registation Date")?></th>
                                                  <th><?=_("Full name")?></th>
                                                  <th><?=_("Email")?></th>
                                                  <th><?=_("Phone")?></th>
                                                  <th><?=_("Actions")?></th>
                                              </tr>
                                              </thead>
                                              <tbody>
                                              <?php foreach($list as $item){
                                                ?>
                                                  <tr>
                                                      <td><?=$item["Id"]?></td>
                                                      <td><?=$utils->PrettyDate($item["RegistrationDate"], false, true)?></td>
                                                      <td><?=$item["FullName"]?></td>
                                                      <td><a href="mailto:<?=$item["Email"]?>"><?=$item["Email"]?></a></td>
                                                      <td><a href="tel:<?=$item["Phone"]?>"><?=$item["Phone"]?></a></td>
                                                      <td width="200">
                                                          <a href="projects.php?uk=<?=$item["Id"]?>"><button  class="btn btn-xs btn-default" title="<?=_("View translations")?>" ><i class="fa fa-file fa-xs"></i></button></a>
                                                      </td>
                                                  </tr>
                                              <?php }?>
                                              </tbody>
                                          </table>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Container-fluid Ends-->
          </div>

          <?php require_once("snippets/footer.php") ?>

          <div class="modal fade" id="main-modal" tabindex="-1" role="dialog">
              <div class="modal-dialog modal-dialog-centered" role="document">
                  <form id="user-form" class="modal-content">
                      <div class="modal-header">
                          <h5 class="modal-title">Add new company account</h5>
                          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                          <input type="hidden" name="Id">
                          <input type="hidden" name="IsCompany" value="0">
                          <strong>Full name</strong>
                          <input name="FullName" type="text" class="form-control" required>
                          <strong>Email</strong>
                          <input name="Email" type="text" class="form-control" required>
                          <strong>Phone</strong>
                          <input name="Phone" type="text" class="form-control">
                      </div>
                      <div class="modal-footer">
                          <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cerrar</button>
                          <button class="btn btn-primary" type="submit">Save</button>
                      </div>
                  </form>
              </div>
          </div>

          <script>
              function changePassword(id){
                  $("#password-modal").modal("show");
                  $("#password-user").val(id);
              }
              document.addEventListener('DOMContentLoaded', function() {
                  $("#password-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-password-client.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      document.getElementById("password-form").reset();
                                      $("#password-modal").modal("hide");
                                  }
                              });
                          }
                      });
                  });

                  $("#user-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/add-update-user.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }else{
                                      AddErrors(result, "user-form");
                                  }
                              });
                          }
                      });
                  });
              });
              function deleteUser(target){
                  DeleteAlert("actions/delete-user.php", target, function(){
                      location.reload();
                  })
              }
              function resetForm(){
                  document.getElementById("user-form").reset();
                  $("input[name=Id]").val("");
              }
              function addEntity(){
                  resetForm();
                  $("#main-modal").modal("show");
              }
              function editUser(target) {
                  $.post("actions/get-user.php", {Id : target}).done(function(result){
                      result = JSON_parser(result);
                      resetForm();
                      if(result!=null){
                          AutomaticAssignment(result, "user-form");
                          $("#main-modal").modal("show");
                      }
                  });
              }
          </script>
      </div>
    </div>
  </body>
</html>