<?php
require_once("snippets/autoload.php");
checkLogin();
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-sm-12">
                          <div class="card">
                              <div class="card-header pb-1">
                                  <h5>
                                     <?=_("Delivered projects")?>
                                  </h5>
                              </div>
                              <div class="card-body">
                                  <div class="row">
                                      <div class="col-xs-12">
                                          <?php
                                          $user = new UserAccount();
                                          $entity = new Request();
                                          $lang = new ActiveLang();
                                          $list = $entity->GetRecordsGlobal('2');
                                          ?>
                                          <table class="table table-bordered table-striped datatable">
                                              <thead>
                                              <tr>
                                                  <th><?=_("ID")?></th>
                                                  <th><?=_("Submission Date")?></th>
                                                  <th><?=_("Translation from-to")?></th>
                                                  <th><?=_("Quoted price")?></th>
                                                  <th><?=_("Client")?></th>
                                                  <th><?=_("Client email")?></th>
                                                  <th><?=_("Client type")?></th>
                                                  <th><?=_("Status")?></th>
                                                  <th><?=_("Actions")?></th>
                                              </tr>
                                              </thead>
                                              <tbody>
                                              <?php
                                              function getStatus($status){
                                                return array("INACTIVE", "WAITING", "DELIVERED","IN PROCESS")[$status];
                                              }
                                              foreach($list as $item){
                                                  $user->Id = $item["UserAccount"];
                                                  $info_user = $user->GetRecord();
                                                  $lang->Id = $item["FromLang"];
                                                  $from = $lang->GetRecord();
                                                  $lang->Id = $item["ToLang"];
                                                  $to = $lang->GetRecord();
                                                ?>
                                                  <tr>
                                                      <td><?=$item["Id"]?></td>
                                                      <td><?=$item["SubmissionDate"]?></td>
                                                      <td><?=$utils->getNameTranslation($from["LangName"])."(".$from["LangName"].")"." - ".$utils->getNameTranslation($to["LangName"])."(".$to["LangName"].")"?></td>
                                                      <td>$<?=number_format($item["EstimatedPrice"], 2)?></td>
                                                      <td><?=$info_user["FullName"]?></td>
                                                      <td><?=$info_user["Email"]?></td>
                                                      <td><?=($info_user["IsCompany"]=="1")?"Company":"External client"?></td>

                                                      <td><?=getStatus($item["Status"])?></td>
                                                      <td>
                                                          <a href="project.php?uk=<?=$item["Id"]?>">
                                                              <button class="btn btn-xs btn-primary" title="<?=_("View project")?>" ><i class="fa fa-file fa-xs"></i></button>
                                                          </a>
                                                      </td>
                                                  </tr>
                                              <?php }?>
                                              </tbody>
                                          </table>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Container-fluid Ends-->
          </div>

          <?php require_once("snippets/footer.php") ?>

          <script>
              function changePassword(id){
                  $("#password-modal").modal("show");
                  $("#password-user").val(id);
              }
              document.addEventListener('DOMContentLoaded', function() {
                  $("#password-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-password-client.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      document.getElementById("password-form").reset();
                                      $("#password-modal").modal("hide");
                                  }
                              });
                          }
                      });
                  });

                  $("#user-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/add-update-user.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }else{
                                      AddErrors(result, "user-form");
                                  }
                              });
                          }
                      });
                  });
              });
              function deleteUser(target){
                  DeleteAlert("actions/delete-user.php", target, function(){
                      location.reload();
                  })
              }
              function resetForm(){
                  document.getElementById("user-form").reset();
                  $("input[name=Id]").val("");
              }
              function addEntity(){
                  resetForm();
                  $("#main-modal").modal("show");
              }
              function editUser(target) {
                  $.post("actions/get-user.php", {Id : target}).done(function(result){
                      result = JSON_parser(result);
                      resetForm();
                      if(result!=null){
                          AutomaticAssignment(result, "user-form");
                          $("#main-modal").modal("show");
                      }
                  });
              }
          </script>
      </div>
    </div>
  </body>
</html>