<header class="main-nav">
  <br>
  <div class="sidebar-user text-center">
    <?php
        $user = new UserAccount();
        $user->Id = $LoggedUser;
        $info = $user->GetRecord();
    ?>
    <img class="img-90 rounded-circle" src="../uploads/user/<?=$info["Avatar"]?>" alt="">
    <div class="badge-bottom">

        <a href="javascript:void(0);" onclick="uploadAvatar()">
            <span class="badge badge-danger" style="border-radius: 100%;"><i  data-feather="upload"></i></span>
        </a>
        <form id="avatar-form">
            <input onchange="$('#avatar-form').submit();" id="avatar" style="display: none" class="form-control" type="file" name="Avatar">
        </form>
    </div>
        <a href="account.php">
            <h6 class="mt-3 f-14 f-w-600"><?=$info["FullName"]?></h6>
        </a>
    <p class="mb-0 font-roboto"><?=_("Administration")?></p>
  </div>
  <nav>
    <div class="main-navbar">
      <div class="left-arrow" id="left-arrow"><i data-feather="arrow-left"></i></div>
      <div id="mainnav">
        <ul class="nav-menu custom-scrollbar">
          <li class="back-btn">
            <div class="mobile-back text-end"><span>Back</span><i class="fa fa-angle-right ps-2" aria-hidden="true"></i></div>
          </li>
          <li class="">
            <a class="nav-link menu-title" href="index.php">
              <i data-feather="home"></i><span><?=_("Dashboard")?></span></a>
          </li>
            <li class="dropdown">
                <a class="nav-link menu-title" href="javascript:void(0)">
                    <i data-feather="file"></i><span><?=_("Translations")?></span>
                </a>
                <ul class="nav-submenu menu-content">
                    <li><a href="quotations.php"><?=_("In process")?></a></li>
                    <li><a href="translations.php"><?=_("Delivered")?></a></li>
                </ul>
            </li>
            <li class="dropdown">
                <a class="nav-link menu-title" href="javascript:void(0)">
                    <i data-feather="users"></i><span><?=_("Users")?></span>
                </a>
                <ul class="nav-submenu menu-content">
                    <li><a href="admins.php"><?=_("Administrators")?></a></li>
                    <li><a href="companies.php"><?=_("Companies")?></a></li>
                    <li><a href="users.php"><?=_("External clients")?></a></li>
                </ul>
            </li>

          <li class="">
            <a class="nav-link menu-title" href="account.php">
              <i data-feather="user"></i><span><?=_("My account")?></span></a>
          </li>
        </ul>
      </div>
      <div class="right-arrow" id="right-arrow"><i data-feather="arrow-right"></i></div>
    </div>
  </nav>
</header>

<script>
    function uploadAvatar(){
        $("#avatar").trigger("click");
    }

    document.addEventListener('DOMContentLoaded', function() {

        $('#avatar-form').submit(function(event){
            event.preventDefault();
            var file_data = $("#avatar").prop('files')[0];
            var form_data = new FormData();
            form_data.append('file', file_data);
            $.ajax({
                url: 'actions/upload-avatar.php', // point to server-side PHP script
                dataType: 'text',  // what to expect back from the PHP script, if anything
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                type: 'post',
                success: function(response){
                    response = JSON.parse(response);
                    AdvancedAlert(response, function(){
                        if(response.type=="success"){
                            location.reload();
                        }
                    });
                }
            });
        });
    });
</script>