<?php
require_once("snippets/autoload.php");
checkLogin();
$project = new Request();
$user = new UserAccount();
$project->Id = $utils->SanitizeString($_GET["uk"]);
$info_project = $project->GetRecord();
$user->Id = $info_project["UserAccount"];
$info_user = $user->GetRecord();
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-xl-3 box-col-6 pe-0">
                          <form id="file-form">
                              <input onchange="$('#file-form').submit();" id="file" style="display: none" class="form-control" type="file" name="File">
                          </form>
                          <div class="job-sidebar">
                              <a class="btn btn-primary job-toggle" href="javascript:void(0)">file filter</a>
                              <div class="job-left-aside custom-scrollbar">
                                  <div class="file-sidebar">
                                      <div class="card">
                                          <div class="card-body">
                                              <ul>
                                                  <li>
                                                      <div class="pricing-plan">
                                                          <h5><?=_("Client info")?> </h5>
                                                          <p> <strong><?=_("Full name")?></strong> <br><?=$info_user["FullName"]?></p>
                                                          <p> <strong>U<?=_("ser type")?></strong> <br> <?=$info_user["IsCompany"]?"Company":"External user"?></p>
                                                          <?php if($info_user["IsCompany"]=="1"){
                                                              ?>
                                                              <p> <strong><?=_("Company Name")?></strong> <br> <?=$info_user["CompanyName"]?></p>
                                                          <?php
                                                          } ?>
                                                          <p> <strong><?=_("Email")?></strong> <br> <?=$info_user["Email"]?></p>
                                                          <p> <strong><?=_("Phone")?></strong> <br> <?=$info_user["Phone"]?></p>

                                                      </div>
                                                  </li>
                                                  <li>
                                                      <div class="pricing-plan">
                                                          <h5><?=_("Project info")?> </h5>
                                                        <?php
                                                        if($info_project["Urgent"]=="1"){
                                                          ?>
                                                            <p> <strong><?=_("URGENT PROJECT")?> </strong></p>
                                                          <?php
                                                        }
                                                        ?>
                                                          <p> <strong><?=_("ID PROJECT")?></strong> <?=$info_project["Id"]?></p>
                                                          <p> <strong><?=_("Submitted on")?></strong> <br> <?=$info_project["SubmissionDate"]?></p>
                                                          <p>
                                                            <strong><?=_("Translated FROM TO")?>: </strong> <br>
                                                              <?php
                                                              $lang = new ActiveLang();
                                                              $lang->Id = $info_project["FromLang"];
                                                              $from = $lang->GetRecord();
                                                              $lang->Id = $info_project["ToLang"];
                                                              $to = $lang->GetRecord(); ?>
                                                            <?=$utils->getNameTranslation($from["LangName"])."(".$from["LangName"].")"." - ".$utils->getNameTranslation($to["LangName"])."(".$to["LangName"].")"?>
                                                          </p>
                                                          <p> <strong><?=_("Process")?></strong> <br> <?=array("INACTIVE", "WAITING", "DELIVERED", "IN PROCESS")[$info_project["Status"]];?></p>
                                                          <p> <strong><?=_("Translation type")?>: </strong> <br> <?=($info_project["Certification"]=="1"?"Certified":"Standar");?></p>



                                                          <p> <strong><?=_("Total pages")?></strong> <br> <?=$info_project["Words"];?></p>
                                                          <div style="float: right" onclick="changeStatus()" class="btn btn-primary ms-2"><i data-feather="check">   </i> Change status  </div>
                                                          <img class="bg-img" src="../assets/images/dashboard/folder.png" alt="">
                                                      </div>
                                                  </li>
                                                  <li>
                                                      <div class="pricing-plan">
                                                          <strong><?=_("Total paid")?></strong>
                                                          <h5>$<?=number_format($info_project["EstimatedPrice"], 2)?></h5>
                                                          <strong><?=_("Payment ID")?></strong> <br>
                                                          <p><?=($info_project["PaymentToken"]!=""?$info_project["PaymentToken"]:"Not set - must be quoted")?></p>
                                                          <p> <strong><?=_("Estimated delivery on")?></strong> <br> <?=($info_project["EstimatedDelivery"]==""?"Not set":$info_project["EstimatedDelivery"])?></p>
                                                          <div style="float: right" onclick="changeDate()" class="btn btn-primary ms-2"><i data-feather="calendar">   </i> Change date  </div>
                                                          <img class="bg-img" src="../assets/images/dashboard/folder1.png" alt="">
                                                      </div>
                                                  </li>
                                              </ul>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                      <div class="col-xl-9 col-md-12 box-col-12">
                          <div class="file-content">
                              <div class="card">
                                  <div class="card-header">
                                       <h4><?=_("Project details ID")?>: <?=$info_project["Id"]?></h4>
                                  </div>
                                  <div class="card-body file-manager">
                                      <div class="card-body">
                                          <div class="default-according" id="accordionclose">
                                              <div class="card">
                                                  <div class="card-header btn-primary" id="collapseh1">
                                                      <h5 class="mb-0">
                                                          <button class="btn btn-link text-white" data-bs-toggle="collapse" data-bs-target="#collapse1" aria-expanded="true">

                                                              <i class="icofont icofont-files"></i>
                                                             <?=_(" Explore the submitted files")?></button>
                                                      </h5>
                                                  </div>
                                                  <div class="collapse" id="collapse1" data-bs-parent="#accordionclose">
                                                      <div class="card-body">
                                                          <iframe width="100%" height="400" src="../core/filemanager/index.php?client=true&uk=<?=$info_project["Id"]?>&type=submitted" frameborder="0"></iframe>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="card">
                                                  <div class="card-header btn-primary" id="collapseh2">
                                                      <h5 class="mb-0">
                                                          <button class="btn btn-link text-white" data-bs-toggle="collapse" data-bs-target="#collapse2" aria-expanded="true">

                                                              <i class="icofont icofont-files"></i>
                                                              <?=_("Explore and upload translated files")?></button>
                                                      </h5>
                                                  </div>
                                                  <div class="collapse" id="collapse2" aria-labelledby="collapseh2" data-bs-parent="#accordionclose">
                                                      <div class="card-body">
                                                          <iframe width="100%" height="400" src="../core/filemanager/full.php?client=false&uk=<?=$info_project["Id"]?>&type=translated" frameborder="0"></iframe>
                                                      </div>
                                                  </div>
                                              </div>

                                          </div>
                                      </div>
                                      <h5 class="mt-4"><?=_("Direct communication with client")?></h5>
                                      <div class="col call-chat-body">
                                          <div class="card">
                                              <div class="card-body p-0">
                                                  <div class="row chat-box">
                                                      <!-- Chat right side start-->
                                                      <div class="col chat-right-aside">
                                                          <!-- chat start-->
                                                          <div class="chat-message clearfix">
                                                              <div class="row">
                                                                  <div class="col-xl-12 d-flex">
                                                                      <form id="comment-form" class="input-group text-box">
                                                                          <input type="hidden" value="<?=$info_project["Id"]?>" name="Request">
                                                                          <input class="form-control input-txt-bx" id="message-to-send" type="text" name="Message" placeholder="<?=_("Type a message")?>......">
                                                                          <button class="btn btn-primary input-group-text" type="submit">SEND</button>
                                                                      </form>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                          <script>
                                                              document.addEventListener('DOMContentLoaded', function() {
                                                                  $("#comment-form").submit(function(e){
                                                                      e.preventDefault();
                                                                      var form_data = new FormData(this);
                                                                      $.ajax({
                                                                          url: 'actions/add-message.php',
                                                                          dataType: 'text',
                                                                          cache: false,
                                                                          contentType: false,
                                                                          processData: false,
                                                                          data: form_data,
                                                                          type: 'post',
                                                                          success: function(response){
                                                                              response = JSON.parse(response);
                                                                              if(response.type == "success"){
                                                                                  location.reload();
                                                                              }else{
                                                                                  alert("<?=_("There was an error adding your comment")?>")
                                                                              }
                                                                          }
                                                                      });
                                                                  });
                                                              });
                                                          </script>
                                                          <div class="chat">
                                                              <div class="chat-history chat-msg-box ">
                                                                  <ul>
                                                                      <?php
                                                                      $msg = new RequestMsg();
                                                                      $msg->Request = $info_project["Id"];
                                                                      $list = $msg->GetRecords();
                                                                      foreach ($list as $item) {
                                                                        ?>
                                                                          <li>
                                                                              <div class="message <?=$item["Sender"]==$LoggedUser?"my-message":"other-message"?>">
                                                                                  <img class="rounded-circle float-<?=$item["Sender"]==$LoggedUser?"start":"end"?> chat-user-img img-30" src="../uploads/user/default.JPG" alt="">
                                                                                  <div class="message-data text-end">
                                                                                      <span class="message-data-time"><?=$utils->PrettyDate($item["DateTimeMsg"], false, true)?></span>
                                                                                  </div>
                                                                                  <?=$item["Message"]?>
                                                                              </div>
                                                                          </li>
                                                                      <?php
                                                                      }
                                                                      ?>
                                                                  </ul>
                                                              </div>

                                                          </div>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>

          <?php require_once("snippets/footer.php") ?>

          <script>
              function changeDate(id){
                  $("#date-modal").modal("show");
              }

              function changeStatus(id){
                  $("#status-modal").modal("show");
              }

              document.addEventListener('DOMContentLoaded', function() {
                  $("#date-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-estimated-date.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }
                              });
                          }
                      });
                  });

                  $("#status-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-status.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }
                              });
                          }
                      });
                  });

                  $('#file-form').submit(function(event){
                      event.preventDefault();
                      var file_data = $("#file").prop('files')[0];
                      var form_data = new FormData();
                      form_data.append('file', file_data);
                      form_data.append('Request', '<?=$info_project["Id"]?>');
                      $.ajax({
                          url: 'actions/upload-file.php', // point to server-side PHP script
                          dataType: 'text',  // what to expect back from the PHP script, if anything
                          cache: false,
                          contentType: false,
                          processData: false,
                          data: form_data,
                          type: 'post',
                          success: function(response){
                              response = JSON.parse(response);
                              AdvancedAlert(response, function(){
                                  if(response.type=="success"){
                                      location.reload();
                                  }
                              });
                          }
                      });
                  });

                  $("#user-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/add-update-user.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }else{
                                      AddErrors(result, "user-form");
                                  }
                              });
                          }
                      });
                  });
              });
              function deleteUser(target){
                  DeleteAlert("actions/delete-user.php", target, function(){
                      location.reload();
                  })
              }
              function resetForm(){
                  document.getElementById("user-form").reset();
                  $("input[name=Id]").val("");
              }
              function addEntity(){
                  resetForm();
                  $("#main-modal").modal("show");
              }
              function editUser(target) {
                  $.post("actions/get-user.php", {Id : target}).done(function(result){
                      result = JSON_parser(result);
                      resetForm();
                      if(result!=null){
                          AutomaticAssignment(result, "user-form");
                          $("#main-modal").modal("show");
                      }
                  });
              }
          </script>
      </div>
    </div>


    <div class="modal fade" id="date-modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <form id="date-form" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?=_("Change estimated date to deliver")?></h5>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="Id" value="<?=$info_project["Id"]?>">
                    <strong><?=_("New date")?></strong>
                    <input name="EstimatedDelivery" type="text" class="form-control date" required value="<?=$info_project["EstimatedDelivery"]?>">
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?=_("Close")?></button>
                    <button class="btn btn-primary" type="submit"><?=_("Save")?></button>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="status-modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <form id="status-form" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?=_("Change status for this project")?></h5>
                    <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="Id" value="<?=$info_project["Id"]?>">
                    <strong><?=_("New status")?></strong>
                    <select name="Status" class="form-control">
                        <option value="1"><?=_("WAITING/HOLDING")?></option>
                        <option value="0"><?=_("INACTIVE")?></option>
                        <option value="3"><?=_("IN PROCESS")?></option>
                        <option value="2"><?=_("DELIVERED/COMPLETED")?></option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-bs-dismiss="modal"><?=_("Close")?></button>
                    <button class="btn btn-primary" type="submit"><?=_("Save")?></button>
                </div>
            </form>
        </div>
    </div>

  </body>
</html>