<?php
require_once("snippets/autoload.php");
checkLogin();

?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-sm-12">
                          <div class="card">
                              <div class="card-header pb-1">
                                  <div style="float: right" onclick="addEntity()" class="btn btn-primary ms-2"><i data-feather="plus">   </i> Add tuple  </div>
                                  <h5>
                                     Language settings
                                  </h5>
                              </div>
                              <div class="card-body">
                                  <div class="row">
                                      <div class="col-xs-12">
                                          <?php
                                          $entity = new ActiveLang();
                                          $list = $entity->GetRecordsPrices();
                                          ?>
                                          <table class="table table-bordered table-striped datatable">
                                              <thead>
                                              <tr>
                                                  <th>Lang tuple</th>
                                                  <th>Price per word</th>
                                                  <th>Actions</th>
                                              </tr>
                                              </thead>
                                              <tbody>
                                              <?php foreach($list as $item){
                                                ?>
                                                  <tr>
                                                      <td><?=$item["FromLang"]." - ".$item["ToLang"]?></td>
                                                      <td>$<?=number_format($item["Price"], 2)?></td>
                                                      <td width="200">
                                                          <button onclick="editLang('<?=$item["Id"]?>', '<?=$item["Price"]?>')" class="btn btn-xs btn-primary" title="Edit user" ><i class="fa fa-edit fa-xs"></i></button>
                                                          <button onclick="deleteLang('<?=$item["Id"]?>')" class="btn btn-xs btn-danger" title="Delete user" ><i class="fa fa-trash fa-xs"></i></button>
                                                      </td>
                                                  </tr>
                                              <?php }?>
                                              </tbody>
                                          </table>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Container-fluid Ends-->
          </div>

          <?php require_once("snippets/footer.php") ?>
          <div class="modal fade" id="main-modal" tabindex="-1" role="dialog">
              <div class="modal-dialog modal-dialog-centered" role="document">
                  <form id="lang-form" class="modal-content">
                      <div class="modal-header">
                          <h5 class="modal-title">Change new price</h5>
                          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                          <input type="hidden" name="Id" id="id-lang">
                          <strong>New price</strong>
                          <input name="Price" id="price-lang" type="text" class="form-control" required>
                      </div>
                      <div class="modal-footer">
                          <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Close</button>
                          <button class="btn btn-primary" type="submit">Save</button>
                      </div>
                  </form>
              </div>
          </div>

          <div class="modal fade" id="langs-modal" tabindex="-1" role="dialog">
              <div class="modal-dialog modal-dialog-centered" role="document">
                  <form id="langs-form" class="modal-content">
                      <div class="modal-header">
                          <h5 class="modal-title">Create a new tuple</h5>
                          <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <div class="modal-body">
                            <?php
                            $lang = new ActiveLang();
                            $list = $lang->GetRecords();
                            ?>
                          <strong>From language</strong>
                          <select name="FromLang" class="form-control">
                              <?php
                              foreach ($list as $item) {
                                ?>
                                  <option value="<?= $item["Id"] ?>"><?=$item["LangName"]?></option>
                              <?php
                              }
                              ?>
                          </select>
                          <strong>To language</strong>
                          <select name="ToLang" class="form-control">
                            <?php
                            foreach ($list as $item) {
                              ?>
                                <option value="<?= $item["Id"] ?>"><?=$item["LangName"]?></option>
                              <?php
                            }
                            ?>
                          </select>
                          <strong>Price per word</strong>
                          <input name="Price" type="text" class="form-control" required>
                      </div>
                      <div class="modal-footer">
                          <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Close</button>
                          <button class="btn btn-primary" type="submit">Save</button>
                      </div>
                  </form>
              </div>
          </div>

          <script>
              function addEntity(id){
                  $("#langs-modal").modal("show");
              }
              document.addEventListener('DOMContentLoaded', function() {

                  $("#lang-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/update-lang-price.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }else{
                                      AddErrors(result, "lang-form");
                                  }
                              });
                          }
                      });
                  });

                  $("#langs-form").submit(function(event){
                      event.preventDefault();
                      $.post("actions/add-lang-price.php", $(this).serialize()).done(function(result){
                          result = JSON_parser(result);
                          if(result!=null){
                              AdvancedAlert(result, function(){
                                  if(result.type == "success"){
                                      location.reload();
                                  }else{
                                      AddErrors(result, "langs-form");
                                  }
                              });
                          }
                      });
                  });
              });
              function deleteLang(target){
                  DeleteAlert("actions/delete-lang-price.php", target, function(){
                      location.reload();
                  })
              }
              function resetForm(){
                  document.getElementById("user-form").reset();
                  $("input[name=Id]").val("");
              }
              function editLang(id, price) {
                  $("#id-lang").val(id);
                  $("#price-lang").val(price);
                  $("#main-modal").modal("show");
              }
          </script>
      </div>
    </div>
  </body>
</html>