<?php
require_once("snippets/autoload.php");
checkLogin();
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <?php require("snippets/head.php"); ?>
  </head>
  <body>
    <div class="page-wrapper compact-wrapper" id="pageWrapper">
        <?php require("snippets/header.php") ?>
      <div class="page-body-wrapper sidebar-icon">
          <?php require_once("snippets/sidebar.php") ?>

          <div class="page-body">
              <div class="container-fluid">
                  <div class="row">
                      <div class="col-sm-12">
                          <div class="card">
                              <div class="card-body">
                                  <div class="row">
                                      <div class="col-xl-5 box-col-12 des-xl-100">
                                          <div class="row">
                                              <div class="col-xl-12 col-md-6 box-col-6 des-xl-50">
                                                  <div class="card profile-greeting" style="background: url('snippets/background.png')">
                                                      <div class="card-body text-center p-t-0">
                                                          <br>
                                                          <h3 class="font-light"><?=_("Welcome Back")?>, <?=explode(" ",$info["FullName"])[0]?>!</h3>
                                                          <p><?=_("Welcome to Precise translations where you can check, update or add comments to current translations")?></p>
                                                          <a href="translations.php"><button class="btn btn-light"><?=_("Go to translations")?></button></a>
                                                      </div>
                                                      <div class="confetti">
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                          <div class="confetti-piece"></div>
                                                      </div>
                                                  </div>
                                              </div>
                                              <?php
                                              $project = new Request();
                                              $project->UserAccount = $LoggedUser;
                                              $cur = count($project->GetRecordsGlobal(1));
                                              $tot = count($project->GetRecordsGlobal(2));
                                              $projects = $project->GetCountByDates();
                                              ?>
                                              <div class="col-xl-6 col-md-3 col-sm-6 box-col-3 des-xl-25 rate-sec">
                                                  <div class="card income-card card-primary">
                                                      <div class="card-body text-center">
                                                          <div class="round-box">
                                                              <i data-feather="check-circle"></i>
                                                          </div>
                                                          <h5><?=$cur?></h5>
                                                          <p><?=_("Current translations")?></p>
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="col-xl-6 col-md-3 col-sm-6 box-col-3 des-xl-25 rate-sec">
                                                  <div class="card income-card card-secondary">
                                                      <div class="card-body text-center">
                                                          <div class="round-box">
                                                              <i data-feather="check-circle"></i>
                                                          </div>
                                                          <h5><?=$tot?></h5>
                                                          <p><?=_("Total translations")?></p>
                                                      </div>
                                                  </div>
                                              </div>
                                          </div>
                                      </div>
                                      <div class="col-xl-7 box-col-12 des-xl-100 dashboard-sec">
                                          <div class="card income-card">
                                              <div class="card-body p-0">
                                                  <div id="chart-timeline1-dashbord"></div>
                                              </div>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <!-- Container-fluid Ends-->
          </div>

          <?php require_once("snippets/footer.php") ?>

          <script src="https://code.highcharts.com/highcharts.js"></script>
          <script src="https://code.highcharts.com/modules/series-label.js"></script>
          <script src="https://code.highcharts.com/modules/exporting.js"></script>
          <script src="https://code.highcharts.com/modules/export-data.js"></script>
          <script src="https://code.highcharts.com/modules/accessibility.js"></script>

          <script>
              function changePassword(id){
                  $("#password-modal").modal("show");
                  $("#password-user").val(id);
              }

                  document.addEventListener('DOMContentLoaded', function() {

                      Highcharts.chart('chart-timeline1-dashbord', {

                          title: {
                              text: '<?=_("My translations")?>'
                          },

                          yAxis: {
                              title: {
                                  text: '<?=_("Translations")?>'
                              }
                          },

                          xAxis: {
                              title: {
                                  text: '<?=_("Month")?>'
                              },
                          },

                          legend: {
                              layout: 'vertical',
                              align: 'right',
                              verticalAlign: 'middle'
                          },

                          series: [{
                            <?php
                            $array = array();
                            foreach ($projects as $project) {
                              array_push($array, "['" . $project["Submission"] . "'," . $project["Total"] . "]");
                            }
                            ?>
                              name: '<?=_("Current translations")?>',
                              data: [<?=implode(", ", $array)?>]
                          }],

                          responsive: {
                              rules: [{
                                  condition: {
                                      maxWidth: 500
                                  },
                                  chartOptions: {
                                      legend: {
                                          layout: 'horizontal',
                                          align: 'center',
                                          verticalAlign: 'bottom'
                                      }
                                  }
                              }]
                          }

                      });


              });

          </script>
      </div>
    </div>
  </body>
</html>