<?php
require("../snippets/autoload.php");

$entity = new UserAccount();


$rules = array(
    "FirstName"=> array("required","Full name"),
    "Email"=> array("required","Email"),
    "Phone"=> array("required","Phone")
);

$exclude = array();

SanitizeRequest($rules, $exclude);

if(count($errors)>0){
    $response_request["title"] = _("Attention!");
    $response_request["content"] = _("There are errors in form, please verify them");
    $response_request["type"] = "error";
    $response_request["Errors"] = $errors;
    $response_request["Validations"] = $validations_errors;
}else {
    AutomaticAssignment($_POST, $entity);
    $entity->Id = $LoggedUser;
    if($entity->UpdateRecord()){
        $response_request["type"] = "success";
        $response_request["title"] = _("Successful proccess");
        $response_request["content"] = _("Your information was updated!");
    }else{
        $response_request["type"] = "error";
        $response_request["title"] = _("Error presented");
        $response_request["content"] = _("An unexpected error happened");
    }
}


echo json_encode($response_request);